/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDocument;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNativeBoolean;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SdkInternalApi
final class StandardAnnotationMaps {
    StandardAnnotationMaps() {
    }

    static final AnnotationMap of(Class<?> objectType) {
        AnnotationMap map = new AnnotationMap();
        map.putAll(objectType.getAnnotations());
        return map;
    }

    static final AnnotationMap of(Method getter, Field field) {
        AnnotationMap map = new AnnotationMap();
        if (getter.getReturnType() != Void.TYPE && getter.getParameterTypes().length == 0) {
            map.putAll(getter.getReturnType().getAnnotations());
        }
        if (field != null) {
            map.putAll(field.getAnnotations());
        }
        map.putAll(getter.getAnnotations());
        return map;
    }

    static final class AnnotationMap {
        private final Map<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();

        private AnnotationMap() {
        }

        private final void putAll(Annotation[] annotations) {
            if (annotations.length > 0) {
                HashMap<Class<? extends Annotation>, Annotation> tmp = new HashMap<Class<? extends Annotation>, Annotation>();
                for (Annotation a1 : annotations) {
                    if (a1.annotationType().isAnnotationPresent(DynamoDB.class)) {
                        if (tmp.containsKey(a1.annotationType())) {
                            throw new DynamoDBMappingException("conflicting annotations " + a1 + " and " + tmp.get(a1.annotationType()) + "; allowed only one of @" + a1.annotationType().getSimpleName());
                        }
                        tmp.put(a1.annotationType(), a1);
                    }
                    for (Annotation a2 : a1.annotationType().getAnnotations()) {
                        if (!a2.annotationType().isAnnotationPresent(DynamoDB.class)) continue;
                        if (tmp.containsKey(a2.annotationType())) {
                            throw new DynamoDBMappingException("conflicting annotations " + a1 + " and " + tmp.get(a2.annotationType()) + "; allowed only one of @" + a2.annotationType().getSimpleName());
                        }
                        tmp.put(a2.annotationType(), a1);
                    }
                }
                this.map.putAll(tmp);
            }
        }

        final boolean has(Class<? extends Annotation> ... annotationTypes) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                if (this.get(annotationType) == null) continue;
                return true;
            }
            return false;
        }

        final <A extends Annotation> A get(Class<A> annotationType) {
            Annotation annotation = this.map.get(annotationType);
            if (annotation != null && annotation.annotationType() != annotationType) {
                return annotation.annotationType().getAnnotation(annotationType);
            }
            return (A)annotation;
        }

        final Annotation autoGenerated() {
            return this.map.get(DynamoDBAutoGenerated.class);
        }

        final DynamoDBAttribute attribute() {
            return this.get(DynamoDBAttribute.class);
        }

        final DynamoDBDocument document() {
            return this.get(DynamoDBDocument.class);
        }

        final DynamoDBHashKey hashKey() {
            return this.get(DynamoDBHashKey.class);
        }

        final DynamoDBIgnore ignore() {
            return this.get(DynamoDBIgnore.class);
        }

        final DynamoDBIndexHashKey indexHashKey() {
            return this.get(DynamoDBIndexHashKey.class);
        }

        final DynamoDBIndexRangeKey indexRangeKey() {
            return this.get(DynamoDBIndexRangeKey.class);
        }

        final DynamoDBMarshalling marshalling() {
            return this.get(DynamoDBMarshalling.class);
        }

        final DynamoDBNativeBoolean nativeBoolean() {
            return this.get(DynamoDBNativeBoolean.class);
        }

        final DynamoDBRangeKey rangeKey() {
            return this.get(DynamoDBRangeKey.class);
        }

        final DynamoDBTable table() {
            return this.get(DynamoDBTable.class);
        }

        final DynamoDBVersionAttribute version() {
            return this.get(DynamoDBVersionAttribute.class);
        }

        final boolean ignored() {
            return this.ignore() != null;
        }

        final String attributeName(String defaultName) {
            String name;
            if (this.hashKey() != null && !(name = this.hashKey().attributeName()).isEmpty()) {
                return name;
            }
            if (this.indexHashKey() != null && !(name = this.indexHashKey().attributeName()).isEmpty()) {
                return name;
            }
            if (this.rangeKey() != null && !(name = this.rangeKey().attributeName()).isEmpty()) {
                return name;
            }
            if (this.indexRangeKey() != null && !(name = this.indexRangeKey().attributeName()).isEmpty()) {
                return name;
            }
            if (this.attribute() != null && !(name = this.attribute().attributeName()).isEmpty()) {
                return name;
            }
            if (this.version() != null && !(name = this.version().attributeName()).isEmpty()) {
                return name;
            }
            return defaultName;
        }

        final KeyType keyType() {
            return this.hashKey() != null ? KeyType.HASH : (this.rangeKey() != null ? KeyType.RANGE : null);
        }

        final boolean indexed() {
            return this.indexHashKey() != null || this.indexRangeKey() != null;
        }

        final List<String> globalSecondaryIndexNames(KeyType keyType) {
            if (keyType == KeyType.HASH && this.indexHashKey() != null) {
                List<String> names = Arrays.asList(this.indexHashKey().globalSecondaryIndexNames());
                if (!this.indexHashKey().globalSecondaryIndexName().isEmpty()) {
                    if (!names.isEmpty()) {
                        throw new DynamoDBMappingException("must not specify both HASH GSI name/names");
                    }
                    return Collections.singletonList(this.indexHashKey().globalSecondaryIndexName());
                }
                if (!names.isEmpty()) {
                    return Collections.unmodifiableList(names);
                }
                throw new DynamoDBMappingException("must specify one of HASH GSI name/names");
            }
            if (keyType == KeyType.RANGE && this.indexRangeKey() != null) {
                List<String> names = Arrays.asList(this.indexRangeKey().globalSecondaryIndexNames());
                if (!this.indexRangeKey().globalSecondaryIndexName().isEmpty()) {
                    if (!names.isEmpty()) {
                        throw new DynamoDBMappingException("must not specify both RANGE GSI name/names");
                    }
                    return Collections.singletonList(this.indexRangeKey().globalSecondaryIndexName());
                }
                if (!names.isEmpty()) {
                    return Collections.unmodifiableList(names);
                }
                if (this.localSecondaryIndexNames().isEmpty()) {
                    throw new DynamoDBMappingException("must specify RANGE GSI and/or LSI name/names");
                }
            }
            return Collections.emptyList();
        }

        final List<String> localSecondaryIndexNames() {
            if (this.indexRangeKey() != null) {
                List<String> names = Arrays.asList(this.indexRangeKey().localSecondaryIndexNames());
                if (!this.indexRangeKey().localSecondaryIndexName().isEmpty()) {
                    if (!names.isEmpty()) {
                        throw new DynamoDBMappingException("must not specify both LSI name/names");
                    }
                    return Collections.singletonList(this.indexRangeKey().localSecondaryIndexName());
                }
                if (!names.isEmpty()) {
                    return Collections.unmodifiableList(names);
                }
            }
            return Collections.emptyList();
        }

        final boolean versioned() {
            return this.version() != null;
        }

        final <T> DynamoDBAutoGenerator<T> autoGenerator(Class<T> targetType) {
            Annotation annotation = this.autoGenerated();
            if (annotation != null) {
                DynamoDBAutoGenerator generator = null;
                try {
                    DynamoDBAutoGenerated generated = this.get(DynamoDBAutoGenerated.class);
                    if (generated != annotation) {
                        try {
                            generator = generated.generator().getConstructor(Class.class, annotation.annotationType()).newInstance(targetType, annotation);
                        }
                        catch (NoSuchMethodException no) {
                            // empty catch block
                        }
                    }
                    if (generator == null) {
                        try {
                            generator = generated.generator().getConstructor(Class.class).newInstance(targetType);
                        }
                        catch (NoSuchMethodException no) {
                            generator = generated.generator().newInstance();
                        }
                    }
                }
                catch (Exception e) {
                    throw new DynamoDBMappingException("could not create auto-generator for " + annotation, e);
                }
                if (this.keyType() != null && generator.getGenerateStrategy() == DynamoDBAutoGenerateStrategy.ALWAYS) {
                    throw new DynamoDBMappingException("must not have auto-generated key with ALWAYS strategy");
                }
                return generator;
            }
            return null;
        }
    }
}

