/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

@SdkInternalApi
final class StandardBeanProperties {
    StandardBeanProperties() {
    }

    static final <T, V> Map<String, BeanProperty<T, V>> of(Class<T> objectType) {
        return new Builder(objectType).build();
    }

    static final class Builder<T, V> {
        private final Map<String, BeanProperty<T, V>> map = new LinkedHashMap<String, BeanProperty<T, V>>();
        private final Class<T> objectType;

        private Builder(Class<T> objectType) {
            this.objectType = objectType;
        }

        private void build(Class<T> clazz) {
            for (Method m : clazz.getMethods()) {
                StandardAnnotationMaps.AnnotationMap annotations;
                if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getReturnType() == Void.TYPE || m.getParameterTypes().length != 0 || m.isBridge() || m.isSynthetic() || m.getDeclaringClass() == Object.class || m.getDeclaringClass() != clazz && (annotations = StandardAnnotationMaps.of(m.getDeclaringClass())).table() == null && annotations.document() == null) continue;
                this.build(m);
            }
        }

        private void build(Method getter) {
            String lower;
            String upper;
            try {
                upper = getter.getName().substring((getter.getName().startsWith("is") ? "is" : "get").length());
                lower = StringUtils.lowerCase((String)upper.substring(0, 1)) + upper.substring(1);
            }
            catch (RuntimeException e) {
                throw new DynamoDBMappingException("getter must begin with 'get' or 'is', and contain at least one character: " + getter, e);
            }
            Field field = null;
            try {
                field = getter.getDeclaringClass().getDeclaredField(lower);
            }
            catch (SecurityException e) {
                throw new DynamoDBMappingException("no access to field for " + getter, e);
            }
            catch (NoSuchFieldException no) {
                // empty catch block
            }
            StandardAnnotationMaps.AnnotationMap annotations = StandardAnnotationMaps.of(getter, field);
            if (annotations.ignored()) {
                return;
            }
            Method setter = null;
            try {
                setter = getter.getDeclaringClass().getMethod("set" + upper, getter.getReturnType());
            }
            catch (Exception no) {
                // empty catch block
            }
            BeanProperty bean = new BeanProperty(getter, setter, field, annotations);
            String name = annotations.attributeName(lower);
            if (this.map.put(name, bean) != null) {
                throw new DynamoDBMappingException("must not duplicate attribute named " + name);
            }
        }

        public Map<String, BeanProperty<T, V>> build() {
            this.build(this.objectType);
            return this.map;
        }
    }

    static final class BeanProperty<T, V>
    implements DynamoDBAutoGenerator<V> {
        private final DynamoDBAutoGenerator<V> generator;
        private final StandardAnnotationMaps.AnnotationMap annotations;
        private final Method getter;
        private final Method setter;
        private final Field field;

        private BeanProperty(Method getter, Method setter, Field field, StandardAnnotationMaps.AnnotationMap annotations) {
            this.getter = getter;
            this.setter = setter;
            this.field = field;
            this.annotations = annotations;
            this.generator = annotations.autoGenerator(this.valueType());
        }

        final StandardAnnotationMaps.AnnotationMap annotations() {
            return this.annotations;
        }

        final Method getter() {
            return this.getter;
        }

        final Method setter() {
            if (this.setter == null) {
                throw new DynamoDBMappingException("no access to public/one-argument setter for " + this.getter);
            }
            return this.setter;
        }

        final Field field() {
            return this.field;
        }

        final Class<V> valueType() {
            return this.getter().getReturnType();
        }

        final V get(T object) {
            try {
                return (V)this.getter().invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.getter + " on " + object.getClass(), e);
            }
        }

        final void set(T object, V value) {
            try {
                this.setter().invoke(object, value);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.setter + " on " + object.getClass(), e);
            }
        }

        @Override
        public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
            return this.generator == null ? null : this.generator.getGenerateStrategy();
        }

        @Override
        public final V generate(V currentValue) {
            return this.generator.generate(currentValue);
        }
    }
}

