/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

@SdkInternalApi
enum StandardTypeConverters {
    DATE_TO_CALENDAR(null, Date.class, Calendar.class, null, new DynamoDBTypeConverter<Date, Calendar>(){

        @Override
        public final Date convert(Calendar object) {
            return object.getTime();
        }

        @Override
        public final Calendar unconvert(Date object) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(object);
            return calendar;
        }
    }),
    DATE_TO_DATE(null, Date.class, Date.class, null, new DynamoDBTypeConverter<Date, Date>(){

        @Override
        public final Date convert(Date object) {
            return object;
        }

        @Override
        public final Date unconvert(Date object) {
            return object;
        }
    }),
    DATE_TO_LONG(null, Date.class, Long.class, null, new DynamoDBTypeConverter<Date, Long>(){

        @Override
        public final Date convert(Long object) {
            return new Date(object);
        }

        @Override
        public final Long unconvert(Date object) {
            return object.getTime();
        }
    }),
    STRING_TO_BIGDECIMAL(ScalarAttributeType.N, String.class, BigDecimal.class, null, new DynamoDBTypeConverter<String, BigDecimal>(){

        @Override
        public final String convert(BigDecimal object) {
            return object.toString();
        }

        @Override
        public final BigDecimal unconvert(String object) {
            return new BigDecimal(object);
        }
    }),
    STRING_TO_BIGINTEGER(ScalarAttributeType.N, String.class, BigInteger.class, null, new DynamoDBTypeConverter<String, BigInteger>(){

        @Override
        public final String convert(BigInteger object) {
            return object.toString();
        }

        @Override
        public final BigInteger unconvert(String object) {
            return new BigInteger(object);
        }
    }),
    STRING_TO_BOOLEAN(ScalarAttributeType.N, String.class, Boolean.class, Boolean.TYPE, new DynamoDBTypeConverter<String, Boolean>(){

        @Override
        public final String convert(Boolean object) {
            return Boolean.TRUE.equals(object) ? "1" : "0";
        }

        @Override
        public final Boolean unconvert(String object) {
            return "0".equals(object) ? Boolean.FALSE : ("1".equals(object) ? Boolean.TRUE : Boolean.valueOf(object));
        }
    }),
    STRING_TO_BYTE(ScalarAttributeType.N, String.class, Byte.class, Byte.TYPE, new DynamoDBTypeConverter<String, Byte>(){

        @Override
        public final String convert(Byte object) {
            return object.toString();
        }

        @Override
        public final Byte unconvert(String object) {
            return Byte.valueOf(object);
        }
    }),
    STRING_TO_CALENDAR(ScalarAttributeType.S, String.class, Calendar.class, null, new DynamoDBTypeConverter<String, Calendar>(){

        @Override
        public final String convert(Calendar object) {
            return DateUtils.formatISO8601Date((Date)object.getTime());
        }

        @Override
        public final Calendar unconvert(String object) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtils.parseISO8601Date((String)object));
            return calendar;
        }
    }),
    STRING_TO_CHARACTER(null, String.class, Character.class, Character.TYPE, new DynamoDBTypeConverter<String, Character>(){

        @Override
        public final String convert(Character object) {
            return object.toString();
        }

        @Override
        public final Character unconvert(String object) {
            return Character.valueOf(object.charAt(0));
        }
    }),
    STRING_TO_DATE(ScalarAttributeType.S, String.class, Date.class, null, new DynamoDBTypeConverter<String, Date>(){

        @Override
        public final String convert(Date object) {
            return DateUtils.formatISO8601Date((Date)object);
        }

        @Override
        public final Date unconvert(String object) {
            return DateUtils.parseISO8601Date((String)object);
        }
    }),
    STRING_TO_DOUBLE(ScalarAttributeType.N, String.class, Double.class, Double.TYPE, new DynamoDBTypeConverter<String, Double>(){

        @Override
        public final String convert(Double object) {
            return object.toString();
        }

        @Override
        public final Double unconvert(String object) {
            return Double.valueOf(object);
        }
    }),
    STRING_TO_FLOAT(ScalarAttributeType.N, String.class, Float.class, Float.TYPE, new DynamoDBTypeConverter<String, Float>(){

        @Override
        public final String convert(Float object) {
            return object.toString();
        }

        @Override
        public final Float unconvert(String object) {
            return Float.valueOf(object);
        }
    }),
    STRING_TO_INTEGER(ScalarAttributeType.N, String.class, Integer.class, Integer.TYPE, new DynamoDBTypeConverter<String, Integer>(){

        @Override
        public final String convert(Integer object) {
            return object.toString();
        }

        @Override
        public final Integer unconvert(String object) {
            return Integer.valueOf(object);
        }
    }),
    STRING_TO_LONG(ScalarAttributeType.N, String.class, Long.class, Long.TYPE, new DynamoDBTypeConverter<String, Long>(){

        @Override
        public final String convert(Long object) {
            return object.toString();
        }

        @Override
        public final Long unconvert(String object) {
            return Long.valueOf(object);
        }
    }),
    STRING_TO_SHORT(ScalarAttributeType.N, String.class, Short.class, Short.TYPE, new DynamoDBTypeConverter<String, Short>(){

        @Override
        public final String convert(Short object) {
            return object.toString();
        }

        @Override
        public final Short unconvert(String object) {
            return Short.valueOf(object);
        }
    }),
    STRING_TO_STRING(ScalarAttributeType.S, String.class, String.class, null, new DynamoDBTypeConverter<String, String>(){

        @Override
        public final String convert(String object) {
            return object;
        }

        @Override
        public final String unconvert(String object) {
            return object;
        }
    }),
    STRING_TO_UUID(ScalarAttributeType.S, String.class, UUID.class, null, new DynamoDBTypeConverter<String, UUID>(){

        @Override
        public final String convert(UUID object) {
            return object.toString();
        }

        @Override
        public final UUID unconvert(String object) {
            return UUID.fromString(object);
        }
    }),
    UUID_TO_STRING(null, UUID.class, String.class, null, new DynamoDBTypeConverter<UUID, String>(){

        @Override
        public final UUID convert(String object) {
            return UUID.fromString(object);
        }

        @Override
        public final String unconvert(UUID object) {
            return object.toString();
        }
    }),
    UUID_TO_UUID(null, UUID.class, UUID.class, null, new DynamoDBTypeConverter<UUID, UUID>(){

        @Override
        public final UUID convert(UUID object) {
            return object;
        }

        @Override
        public final UUID unconvert(UUID object) {
            return object;
        }
    });

    private final DynamoDBTypeConverter<?, ?> converter;
    private final ScalarAttributeType scalarAttributeType;
    private final Class<?> sourceType;
    private final Class<?> targetType;
    private final Class<?> primitiveTargetType;

    private StandardTypeConverters(ScalarAttributeType scalarAttributeType, Class<?> sourceType, Class<?> targetType, Class<?> primitiveTargetType, DynamoDBTypeConverter<?, ?> converter) {
        this.converter = converter;
        this.scalarAttributeType = scalarAttributeType;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.primitiveTargetType = primitiveTargetType;
    }

    final <S, T> DynamoDBTypeConverter<S, T> converter() {
        return this.converter;
    }

    final ScalarAttributeType scalarAttributeType() {
        return this.scalarAttributeType;
    }

    final <S> Class<S> sourceType() {
        return this.sourceType;
    }

    final <T> Class<T> targetType() {
        return this.targetType;
    }

    final <T> Class<T> primitiveTargetType() {
        return this.primitiveTargetType;
    }

    final <S, T> boolean isAssignableFrom(Class<S> sourceType, Class<T> targetType, boolean primitive) {
        if (this.sourceType == sourceType) {
            if (!targetType.isPrimitive()) {
                return this.targetType.isAssignableFrom(targetType);
            }
            if (primitive && this.primitiveTargetType != null) {
                return this.primitiveTargetType.isAssignableFrom(targetType);
            }
        }
        return false;
    }

    static final <S, T> DynamoDBTypeConverter<S, T> of(Class<S> sourceType, Class<T> targetType, boolean primitive) {
        if (targetType.isEnum()) {
            return new StringToEnum<T>(targetType);
        }
        for (StandardTypeConverters c : StandardTypeConverters.values()) {
            if (!c.isAssignableFrom(sourceType, targetType, primitive)) continue;
            return c.converter();
        }
        throw new DynamoDBMappingException("unsupported " + sourceType + " to " + targetType);
    }

    static final class StringToEnum<T extends Enum<T>>
    implements DynamoDBTypeConverter<String, T> {
        private final Class<T> targetType;

        public StringToEnum(Class<T> targetType) {
            if (!targetType.isEnum()) {
                throw new DynamoDBMappingException("unsupported " + targetType + "; expected Enum");
            }
            this.targetType = targetType;
        }

        @Override
        public final String convert(T object) {
            return ((Enum)object).name();
        }

        @Override
        public final T unconvert(String object) {
            return Enum.valueOf(this.targetType, object);
        }
    }
}

