/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)queryRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.Query";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag attributeValueListList;
            ListWithAutoConstructFlag attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (queryRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)queryRequest.getTableName());
            }
            if (queryRequest.getIndexName() != null) {
                jsonWriter.key("IndexName").value((Object)queryRequest.getIndexName());
            }
            if (queryRequest.getSelect() != null) {
                jsonWriter.key("Select").value((Object)queryRequest.getSelect());
            }
            if (!((attributesToGetList = (ListWithAutoConstructFlag)queryRequest.getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                jsonWriter.key("AttributesToGet");
                jsonWriter.array();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonWriter.value((Object)string);
                }
                jsonWriter.endArray();
            }
            if (queryRequest.getLimit() != null) {
                jsonWriter.key("Limit").value((Object)queryRequest.getLimit());
            }
            if (queryRequest.isConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value((Object)queryRequest.isConsistentRead());
            }
            if (queryRequest.getKeyConditions() != null) {
                jsonWriter.key("KeyConditions");
                jsonWriter.object();
                for (Map.Entry<String, Condition> entry : queryRequest.getKeyConditions().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    attributeValueListList = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(attributeValueListList == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            if (attributeValueListListValue == null) continue;
                            AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                        }
                        jsonWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value((Object)entry.getValue().getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getQueryFilter() != null) {
                jsonWriter.key("QueryFilter");
                jsonWriter.object();
                for (Map.Entry<String, Condition> entry : queryRequest.getQueryFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    attributeValueListList = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(attributeValueListList == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            if (attributeValueListListValue == null) continue;
                            AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                        }
                        jsonWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value((Object)entry.getValue().getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value((Object)queryRequest.getConditionalOperator());
            }
            if (queryRequest.isScanIndexForward() != null) {
                jsonWriter.key("ScanIndexForward").value((Object)queryRequest.isScanIndexForward());
            }
            if (queryRequest.getExclusiveStartKey() != null) {
                jsonWriter.key("ExclusiveStartKey");
                jsonWriter.object();
                for (Map.Entry<String, Cloneable> entry : queryRequest.getExclusiveStartKey().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value((Object)queryRequest.getReturnConsumedCapacity());
            }
            if (queryRequest.getProjectionExpression() != null) {
                jsonWriter.key("ProjectionExpression").value((Object)queryRequest.getProjectionExpression());
            }
            if (queryRequest.getFilterExpression() != null) {
                jsonWriter.key("FilterExpression").value((Object)queryRequest.getFilterExpression());
            }
            if (queryRequest.getExpressionAttributeNames() != null) {
                jsonWriter.key("ExpressionAttributeNames");
                jsonWriter.object();
                for (Map.Entry<String, Object> entry : queryRequest.getExpressionAttributeNames().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.value(entry.getValue());
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getExpressionAttributeValues() != null) {
                jsonWriter.key("ExpressionAttributeValues");
                jsonWriter.object();
                for (Map.Entry<String, Object> entry : queryRequest.getExpressionAttributeValues().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

