/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.ComparisonOperator;
import com.amazonaws.services.lakeformation.model.FieldNameString;
import com.amazonaws.services.lakeformation.model.transform.FilterConditionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterCondition
implements Serializable,
Cloneable,
StructuredPojo {
    private String field;
    private String comparisonOperator;
    private List<String> stringValueList;

    public void setField(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public FilterCondition withField(String field) {
        this.setField(field);
        return this;
    }

    public FilterCondition withField(FieldNameString field) {
        this.field = field.toString();
        return this;
    }

    public void setComparisonOperator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public String getComparisonOperator() {
        return this.comparisonOperator;
    }

    public FilterCondition withComparisonOperator(String comparisonOperator) {
        this.setComparisonOperator(comparisonOperator);
        return this;
    }

    public FilterCondition withComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator.toString();
        return this;
    }

    public List<String> getStringValueList() {
        return this.stringValueList;
    }

    public void setStringValueList(Collection<String> stringValueList) {
        if (stringValueList == null) {
            this.stringValueList = null;
            return;
        }
        this.stringValueList = new ArrayList<String>(stringValueList);
    }

    public FilterCondition withStringValueList(String ... stringValueList) {
        if (this.stringValueList == null) {
            this.setStringValueList(new ArrayList<String>(stringValueList.length));
        }
        for (String ele : stringValueList) {
            this.stringValueList.add(ele);
        }
        return this;
    }

    public FilterCondition withStringValueList(Collection<String> stringValueList) {
        this.setStringValueList(stringValueList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getField() != null) {
            sb.append("Field: ").append(this.getField()).append(",");
        }
        if (this.getComparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.getComparisonOperator()).append(",");
        }
        if (this.getStringValueList() != null) {
            sb.append("StringValueList: ").append(this.getStringValueList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCondition)) {
            return false;
        }
        FilterCondition other = (FilterCondition)obj;
        if (other.getField() == null ^ this.getField() == null) {
            return false;
        }
        if (other.getField() != null && !other.getField().equals(this.getField())) {
            return false;
        }
        if (other.getComparisonOperator() == null ^ this.getComparisonOperator() == null) {
            return false;
        }
        if (other.getComparisonOperator() != null && !other.getComparisonOperator().equals(this.getComparisonOperator())) {
            return false;
        }
        if (other.getStringValueList() == null ^ this.getStringValueList() == null) {
            return false;
        }
        return other.getStringValueList() == null || other.getStringValueList().equals(this.getStringValueList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getField() == null ? 0 : this.getField().hashCode());
        hashCode = 31 * hashCode + (this.getComparisonOperator() == null ? 0 : this.getComparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.getStringValueList() == null ? 0 : this.getStringValueList().hashCode());
        return hashCode;
    }

    public FilterCondition clone() {
        try {
            return (FilterCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

