/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transcribe.model.LanguageCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateVocabularyFilterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String vocabularyFilterName;
    private String languageCode;
    private List<String> words;
    private String vocabularyFilterFileUri;

    public void setVocabularyFilterName(String vocabularyFilterName) {
        this.vocabularyFilterName = vocabularyFilterName;
    }

    public String getVocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public CreateVocabularyFilterRequest withVocabularyFilterName(String vocabularyFilterName) {
        this.setVocabularyFilterName(vocabularyFilterName);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public CreateVocabularyFilterRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public CreateVocabularyFilterRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public List<String> getWords() {
        return this.words;
    }

    public void setWords(Collection<String> words) {
        if (words == null) {
            this.words = null;
            return;
        }
        this.words = new ArrayList<String>(words);
    }

    public CreateVocabularyFilterRequest withWords(String ... words) {
        if (this.words == null) {
            this.setWords(new ArrayList<String>(words.length));
        }
        for (String ele : words) {
            this.words.add(ele);
        }
        return this;
    }

    public CreateVocabularyFilterRequest withWords(Collection<String> words) {
        this.setWords(words);
        return this;
    }

    public void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
        this.vocabularyFilterFileUri = vocabularyFilterFileUri;
    }

    public String getVocabularyFilterFileUri() {
        return this.vocabularyFilterFileUri;
    }

    public CreateVocabularyFilterRequest withVocabularyFilterFileUri(String vocabularyFilterFileUri) {
        this.setVocabularyFilterFileUri(vocabularyFilterFileUri);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVocabularyFilterName() != null) {
            sb.append("VocabularyFilterName: ").append(this.getVocabularyFilterName()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getWords() != null) {
            sb.append("Words: ").append(this.getWords()).append(",");
        }
        if (this.getVocabularyFilterFileUri() != null) {
            sb.append("VocabularyFilterFileUri: ").append(this.getVocabularyFilterFileUri());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyFilterRequest)) {
            return false;
        }
        CreateVocabularyFilterRequest other = (CreateVocabularyFilterRequest)obj;
        if (other.getVocabularyFilterName() == null ^ this.getVocabularyFilterName() == null) {
            return false;
        }
        if (other.getVocabularyFilterName() != null && !other.getVocabularyFilterName().equals(this.getVocabularyFilterName())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getWords() == null ^ this.getWords() == null) {
            return false;
        }
        if (other.getWords() != null && !other.getWords().equals(this.getWords())) {
            return false;
        }
        if (other.getVocabularyFilterFileUri() == null ^ this.getVocabularyFilterFileUri() == null) {
            return false;
        }
        return other.getVocabularyFilterFileUri() == null || other.getVocabularyFilterFileUri().equals(this.getVocabularyFilterFileUri());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVocabularyFilterName() == null ? 0 : this.getVocabularyFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getWords() == null ? 0 : this.getWords().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFilterFileUri() == null ? 0 : this.getVocabularyFilterFileUri().hashCode());
        return hashCode;
    }

    public CreateVocabularyFilterRequest clone() {
        return (CreateVocabularyFilterRequest)super.clone();
    }
}

