/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transcribe.model.LanguageCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateVocabularyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String vocabularyName;
    private String languageCode;
    private List<String> phrases;
    private String vocabularyFileUri;
    private String dataAccessRoleArn;

    public void setVocabularyName(String vocabularyName) {
        this.vocabularyName = vocabularyName;
    }

    public String getVocabularyName() {
        return this.vocabularyName;
    }

    public UpdateVocabularyRequest withVocabularyName(String vocabularyName) {
        this.setVocabularyName(vocabularyName);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public UpdateVocabularyRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public UpdateVocabularyRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public List<String> getPhrases() {
        return this.phrases;
    }

    public void setPhrases(Collection<String> phrases) {
        if (phrases == null) {
            this.phrases = null;
            return;
        }
        this.phrases = new ArrayList<String>(phrases);
    }

    public UpdateVocabularyRequest withPhrases(String ... phrases) {
        if (this.phrases == null) {
            this.setPhrases(new ArrayList<String>(phrases.length));
        }
        for (String ele : phrases) {
            this.phrases.add(ele);
        }
        return this;
    }

    public UpdateVocabularyRequest withPhrases(Collection<String> phrases) {
        this.setPhrases(phrases);
        return this;
    }

    public void setVocabularyFileUri(String vocabularyFileUri) {
        this.vocabularyFileUri = vocabularyFileUri;
    }

    public String getVocabularyFileUri() {
        return this.vocabularyFileUri;
    }

    public UpdateVocabularyRequest withVocabularyFileUri(String vocabularyFileUri) {
        this.setVocabularyFileUri(vocabularyFileUri);
        return this;
    }

    public void setDataAccessRoleArn(String dataAccessRoleArn) {
        this.dataAccessRoleArn = dataAccessRoleArn;
    }

    public String getDataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public UpdateVocabularyRequest withDataAccessRoleArn(String dataAccessRoleArn) {
        this.setDataAccessRoleArn(dataAccessRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVocabularyName() != null) {
            sb.append("VocabularyName: ").append(this.getVocabularyName()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getPhrases() != null) {
            sb.append("Phrases: ").append(this.getPhrases()).append(",");
        }
        if (this.getVocabularyFileUri() != null) {
            sb.append("VocabularyFileUri: ").append(this.getVocabularyFileUri()).append(",");
        }
        if (this.getDataAccessRoleArn() != null) {
            sb.append("DataAccessRoleArn: ").append(this.getDataAccessRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyRequest)) {
            return false;
        }
        UpdateVocabularyRequest other = (UpdateVocabularyRequest)obj;
        if (other.getVocabularyName() == null ^ this.getVocabularyName() == null) {
            return false;
        }
        if (other.getVocabularyName() != null && !other.getVocabularyName().equals(this.getVocabularyName())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getPhrases() == null ^ this.getPhrases() == null) {
            return false;
        }
        if (other.getPhrases() != null && !other.getPhrases().equals(this.getPhrases())) {
            return false;
        }
        if (other.getVocabularyFileUri() == null ^ this.getVocabularyFileUri() == null) {
            return false;
        }
        if (other.getVocabularyFileUri() != null && !other.getVocabularyFileUri().equals(this.getVocabularyFileUri())) {
            return false;
        }
        if (other.getDataAccessRoleArn() == null ^ this.getDataAccessRoleArn() == null) {
            return false;
        }
        return other.getDataAccessRoleArn() == null || other.getDataAccessRoleArn().equals(this.getDataAccessRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVocabularyName() == null ? 0 : this.getVocabularyName().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getPhrases() == null ? 0 : this.getPhrases().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFileUri() == null ? 0 : this.getVocabularyFileUri().hashCode());
        hashCode = 31 * hashCode + (this.getDataAccessRoleArn() == null ? 0 : this.getDataAccessRoleArn().hashCode());
        return hashCode;
    }

    public UpdateVocabularyRequest clone() {
        return (UpdateVocabularyRequest)super.clone();
    }
}

