/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.entity.Area;
import com.apifan.common.random.source.AreaSource;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EducationSource {
    private static final Logger logger = LoggerFactory.getLogger(EducationSource.class);
    private static final List<String> degreeList = Lists.newArrayList((Object[])new String[]{"\u5c0f\u5b66", "\u521d\u4e2d", "\u4e2d\u4e13/\u804c\u4e1a\u9ad8\u4e2d", "\u9ad8\u4e2d", "\u5927\u5b66\u4e13\u79d1", "\u5927\u5b66\u672c\u79d1", "\u7855\u58eb", "\u535a\u58eb"});
    private static final EducationSource instance = new EducationSource();
    private List<String> collegeList = ResourceUtils.readLines("college.txt");
    private static final List<String> numberList = Lists.newArrayList((Object[])new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"});
    private List<String> majorList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("college-major.txt"));

    private EducationSource() {
    }

    public static EducationSource getInstance() {
        return instance;
    }

    public String randomCollege() {
        return ResourceUtils.getRandomElement(this.collegeList);
    }

    public String randomDegree() {
        return ResourceUtils.getRandomElement(degreeList);
    }

    public String randomPrimarySchoolName() {
        return this.randomSchoolName("\u5c0f\u5b66");
    }

    public String randomPrimarySchoolGrade() {
        return this.getGradeName(RandomUtils.nextInt((int)1, (int)7)) + "\u5e74\u7ea7";
    }

    public String randomHighSchoolName() {
        return this.randomSchoolName("\u4e2d\u5b66");
    }

    public String randomHighSchoolGrade() {
        String prefix;
        int grade = RandomUtils.nextInt((int)1, (int)7);
        if (grade > 3) {
            prefix = "\u9ad8";
            grade -= 3;
        } else {
            prefix = "\u521d";
        }
        return prefix + this.getGradeName(grade) + "\u5e74\u7ea7";
    }

    public String randomClassName() {
        return RandomUtils.nextInt((int)1, (int)11) + "\u73ed";
    }

    public String randomMajorName() {
        return ResourceUtils.getRandomElement(this.majorList);
    }

    private String getGradeName(int grade) {
        Preconditions.checkArgument((grade > 0 && grade < numberList.size() ? 1 : 0) != 0, (Object)"grade\u6570\u5b57\u9519\u8bef");
        return numberList.get(grade - 1);
    }

    private String randomSchoolName(String suffix) {
        Area area = AreaSource.getInstance().nextArea();
        return area.getCity() + "\u7b2c" + ResourceUtils.getRandomString(numberList, 1) + suffix;
    }
}

