/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.constant.RandomConstant;
import com.apifan.common.random.entity.IpRange;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetSource {
    private static final Logger logger = LoggerFactory.getLogger(InternetSource.class);
    private static final String[] ANDROID_MANUFACTURERS = new String[]{"samsung", "sony", "huawei", "honor", "xiaomi", "redmi", "mi", "vivo", "oppo", "oneplus", "lg", "lenovo", "motorola", "nokia", "meizu", "zte", "asus", "smartisan", "nubia", "realme", "iqoo", "coolpad", "gionee"};
    private static final String ANDROID_TEMPLATE = "Mozilla/5.0 (Linux; U; Android %d.0.0; zh-cn; %s-%s Build/%s) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/74.0.3729.157 Mobile Safari/537.36";
    private static final String IOS_TEMPLATE = "Mozilla/5.0 (iPhone; CPU iPhone OS %s like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/%s";
    private static final String[] IOS_VERSIONS = new String[]{"10_0", "10_1", "10_2", "10_3", "11_0", "11_1", "11_2", "11_3", "11_4", "12_0", "12_4", "13_0", "13_7", "14_0", "14_7", "15_0", "15_7", "16_0"};
    private static final String[] WINDOWS_VERSIONS = new String[]{"6.0", "6.1", "6.2", "6.3", "10.0", "11.0"};
    private static final String PC_TEMPLATE = "Mozilla/5.0 (Windows NT %s; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%d.0.%d.%d Safari/537.36";
    private List<IpRange> ipRangeList = Lists.newArrayList();
    private static final InternetSource instance = new InternetSource();

    private InternetSource() {
        try {
            List<String> areaLines = ResourceUtils.readLines("cn-ip.csv");
            if (CollectionUtils.isNotEmpty(areaLines)) {
                areaLines.forEach(i -> {
                    if (StringUtils.isEmpty((CharSequence)i)) {
                        return;
                    }
                    List row = Splitter.on((String)",").splitToList((CharSequence)i);
                    IpRange range = new IpRange();
                    range.setBeginIp((String)row.get(0));
                    range.setBeginIpNum(this.ipv4ToLong(range.getBeginIp()));
                    range.setEndIp((String)row.get(1));
                    range.setEndIpNum(this.ipv4ToLong(range.getEndIp()));
                    this.ipRangeList.add(range);
                });
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public static InternetSource getInstance() {
        return instance;
    }

    public String randomEmail(int maxLength) {
        return this.randomEmail(maxLength, null);
    }

    public String randomEmail(int maxLength, String suffix) {
        Preconditions.checkArgument((maxLength >= 2 ? 1 : 0) != 0, (Object)"\u90ae\u7bb1\u7528\u6237\u540d\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e2");
        if (StringUtils.isBlank((CharSequence)suffix)) {
            suffix = this.randomDomain(RandomUtils.nextInt((int)2, (int)(maxLength + 1)));
        }
        String email = RandomStringUtils.randomAlphanumeric((int)2, (int)(maxLength + 1)) + "@" + suffix;
        return email.toLowerCase();
    }

    public String randomDomain(int maxLength) {
        Preconditions.checkArgument((maxLength >= 2 ? 1 : 0) != 0, (Object)"\u57df\u540d\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e2");
        String domain = RandomStringUtils.randomAlphanumeric((int)2, (int)(maxLength + 1)) + "." + ResourceUtils.getRandomElement(RandomConstant.domainSuffixList);
        return domain.toLowerCase();
    }

    public String randomStaticUrl(String suffix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)suffix), (Object)"\u540e\u7f00\u4e3a\u7a7a");
        String domain = this.randomDomain(16);
        String prefix = "http://";
        int x = RandomUtils.nextInt((int)0, (int)101);
        if (x % 3 == 0) {
            prefix = "https://";
        }
        return prefix + domain.toLowerCase() + "/" + RandomUtils.nextLong((long)1L, (long)10000000000001L) + "/" + RandomStringUtils.randomAlphanumeric((int)8, (int)33) + "." + suffix;
    }

    public String randomPublicIpv4() {
        IpRange range = ResourceUtils.getRandomElement(this.ipRangeList);
        if (range == null) {
            return null;
        }
        long ipv4Num = RandomUtils.nextLong((long)range.getBeginIpNum(), (long)range.getEndIpNum());
        return this.longToIpv4(ipv4Num);
    }

    public String randomPrivateIpv4() {
        int x = RandomUtils.nextInt((int)1, (int)101);
        if (x % 2 == 0) {
            return "10." + RandomUtils.nextInt((int)0, (int)256) + "." + RandomUtils.nextInt((int)0, (int)256) + "." + RandomUtils.nextInt((int)0, (int)256);
        }
        if (x % 3 == 0) {
            return "172." + RandomUtils.nextInt((int)16, (int)32) + "." + RandomUtils.nextInt((int)0, (int)256) + "." + RandomUtils.nextInt((int)0, (int)256);
        }
        return "192.168." + RandomUtils.nextInt((int)0, (int)256) + "." + RandomUtils.nextInt((int)0, (int)256);
    }

    public String randomPCUserAgent() {
        return String.format(PC_TEMPLATE, WINDOWS_VERSIONS[RandomUtils.nextInt((int)0, (int)WINDOWS_VERSIONS.length)], RandomUtils.nextInt((int)60, (int)100), RandomUtils.nextInt((int)2000, (int)4000), RandomUtils.nextInt((int)1, (int)200));
    }

    public String randomAndroidUserAgent() {
        int androidVersion = RandomUtils.nextInt((int)7, (int)13);
        return String.format(ANDROID_TEMPLATE, androidVersion, ANDROID_MANUFACTURERS[RandomUtils.nextInt((int)0, (int)ANDROID_MANUFACTURERS.length)].toUpperCase(), RandomStringUtils.randomAlphanumeric((int)6).toUpperCase(), RandomStringUtils.randomAlphanumeric((int)6).toUpperCase());
    }

    public String randomIOSUserAgent() {
        return String.format(IOS_TEMPLATE, IOS_VERSIONS[RandomUtils.nextInt((int)0, (int)IOS_VERSIONS.length)], RandomStringUtils.randomAlphanumeric((int)6).toUpperCase());
    }

    public String randomMacAddress(String splitter) {
        int count = 6;
        ArrayList<String> mac = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            int n = RandomUtils.nextInt((int)0, (int)255);
            mac.add(String.format("%02x", n));
        }
        return Joiner.on((String)(StringUtils.isNotEmpty((CharSequence)splitter) ? splitter : "-")).join(mac).toUpperCase();
    }

    public int randomPort() {
        return RandomUtils.nextInt((int)1025, (int)65535);
    }

    public String randomAppBundleId() {
        String bundleId = ResourceUtils.getRandomElement(RandomConstant.domainSuffixList) + "." + RandomStringUtils.randomAlphabetic((int)2, (int)21) + "." + RandomStringUtils.randomAlphabetic((int)2, (int)21);
        return bundleId.toLowerCase();
    }

    public String randomAppVersionCode() {
        return RandomUtils.nextInt((int)1, (int)11) + "." + RandomUtils.nextInt((int)0, (int)100) + "." + RandomUtils.nextInt((int)0, (int)1000);
    }

    public String randomAppName() {
        return WordUtils.capitalize((String)RandomStringUtils.randomAlphabetic((int)4, (int)11).toLowerCase());
    }

    public String randomIpV6() {
        ArrayList numbers = Lists.newArrayList();
        for (int i = 0; i < 8; ++i) {
            numbers.add(Integer.toHexString(RandomUtils.nextInt((int)0, (int)65535)));
        }
        return Joiner.on((String)":").join((Iterable)numbers);
    }

    private long ipv4ToLong(String ipv4) {
        String[] part = ipv4.split("\\.");
        long num = 0L;
        for (int i = 0; i < part.length; ++i) {
            int power = 3 - i;
            num = (long)((double)num + (double)(Integer.parseInt(part[i]) % 256) * Math.pow(256.0, power));
        }
        return num;
    }

    private String longToIpv4(long ipv4Num) {
        StringBuilder result = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            result.insert(0, ipv4Num & 0xFFL);
            if (i < 3) {
                result.insert(0, '.');
            }
            ipv4Num >>= 8;
        }
        return result.toString();
    }
}

