/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util.json.impl;

import com.apifan.common.random.util.json.JsonConverter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonConverter
implements JsonConverter {
    private static final Logger log = LoggerFactory.getLogger(JacksonConverter.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public <T> T parseObject(String text, Class<T> targetClass) {
        try {
            return (T)mapper.readValue(text, targetClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Map<String, Object>> parseMapList(String text) {
        CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(List.class, Map.class);
        try {
            return (List)mapper.readValue(text, (JavaType)collectionType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> parseObjectList(String text, Class<T> targetClass) {
        try {
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(List.class, targetClass);
            return (List)mapper.readValue(text, (JavaType)collectionType);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

