/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.vertx.implementation.BufferedVertxHttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressReporter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.util.Objects;
import java.util.concurrent.Executor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

class VertxAsyncHttpClient
implements HttpClient {
    private final Scheduler scheduler;
    final io.vertx.core.http.HttpClient client;

    VertxAsyncHttpClient(io.vertx.core.http.HttpClient client, Vertx vertx) {
        Objects.requireNonNull(client, "client cannot be null");
        Objects.requireNonNull(vertx, "vertx cannot be null");
        this.client = client;
        this.scheduler = Schedulers.fromExecutor((Executor)vertx.nettyEventLoopGroup());
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.valueOf((String)request.getHttpMethod().name())).setAbsoluteURI(request.getUrl());
        return Mono.create(sink -> this.client.request(options, requestResult -> {
            if (requestResult.failed()) {
                sink.error(requestResult.cause());
                return;
            }
            HttpClientRequest vertxHttpRequest = (HttpClientRequest)requestResult.result();
            vertxHttpRequest.exceptionHandler(arg_0 -> ((MonoSink)sink).error(arg_0));
            request.getHeaders().stream().forEach(header -> vertxHttpRequest.putHeader(header.getName(), (Iterable)header.getValuesList()));
            if (request.getHeaders().get("Content-Length") == null) {
                vertxHttpRequest.setChunked(true);
            }
            vertxHttpRequest.response(event -> {
                if (event.succeeded()) {
                    HttpClientResponse vertxHttpResponse = (HttpClientResponse)event.result();
                    vertxHttpResponse.exceptionHandler(arg_0 -> ((MonoSink)sink).error(arg_0));
                    vertxHttpResponse.body(bodyEvent -> {
                        if (bodyEvent.succeeded()) {
                            sink.success((Object)new BufferedVertxHttpResponse(request, vertxHttpResponse, (Buffer)bodyEvent.result()));
                        } else {
                            sink.error(bodyEvent.cause());
                        }
                    });
                } else {
                    sink.error(event.cause());
                }
            });
            Flux requestBody = request.getBody();
            if (requestBody == null) {
                vertxHttpRequest.end();
            } else {
                if (progressReporter != null) {
                    requestBody = requestBody.map(buffer -> {
                        progressReporter.reportProgress((long)buffer.remaining());
                        return buffer;
                    });
                }
                FluxUtil.collectBytesFromNetworkResponse((Flux)requestBody, (HttpHeaders)request.getHeaders()).subscribeOn(this.scheduler).subscribe(bytes -> vertxHttpRequest.write((Object)Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes))), arg_0 -> ((MonoSink)sink).error(arg_0), () -> ((HttpClientRequest)vertxHttpRequest).end());
            }
        }));
    }
}

