/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.vertx.VertxAsyncHttpClient;
import com.azure.core.http.vertx.VertxProvider;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.ProxyType;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class VertxAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(VertxAsyncHttpClientBuilder.class);
    private static final Pattern NON_PROXY_HOSTS_SPLIT = Pattern.compile("(?<!\\\\)\\|");
    private static final Pattern NON_PROXY_HOST_DESANITIZE = Pattern.compile("(\\?|\\\\|\\(|\\)|\\\\E|\\\\Q|\\.\\.)");
    private static final Pattern NON_PROXY_HOST_DOT_STAR = Pattern.compile("(\\.\\*)");
    private static final long DEFAULT_CONNECT_TIMEOUT;
    private static final long DEFAULT_WRITE_TIMEOUT;
    private static final long DEFAULT_READ_TIMEOUT;
    private Duration readIdleTimeout;
    private Duration writeIdleTimeout;
    private Duration connectTimeout;
    private Duration idleTimeout = Duration.ofSeconds(60L);
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private HttpClientOptions httpClientOptions;
    private Vertx vertx;

    public VertxAsyncHttpClientBuilder readIdleTimeout(Duration readIdleTimeout) {
        this.readIdleTimeout = readIdleTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder writeIdleTimeout(Duration writeIdleTimeout) {
        this.writeIdleTimeout = writeIdleTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder idleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public VertxAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public VertxAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public VertxAsyncHttpClientBuilder httpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public VertxAsyncHttpClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public HttpClient build() {
        Vertx configuredVertx = this.vertx;
        if (configuredVertx == null) {
            ServiceLoader<VertxProvider> vertxProviders = ServiceLoader.load(VertxProvider.class, VertxProvider.class.getClassLoader());
            Iterator<VertxProvider> iterator = vertxProviders.iterator();
            if (iterator.hasNext()) {
                VertxProvider provider = iterator.next();
                configuredVertx = provider.createVertx();
                LOGGER.verbose("Using {} as the VertxProvider.", new Object[]{provider.getClass().getName()});
                while (iterator.hasNext()) {
                    VertxProvider ignoredProvider = iterator.next();
                    LOGGER.warning("Multiple VertxProviders were found on the classpath, ignoring {}.", new Object[]{ignoredProvider.getClass().getName()});
                }
            } else {
                configuredVertx = DefaultVertx.DEFAULT_VERTX.getVertx();
            }
        }
        if (this.httpClientOptions == null) {
            ProxyOptions buildProxyOptions;
            this.httpClientOptions = new HttpClientOptions();
            if (this.connectTimeout != null) {
                this.httpClientOptions.setConnectTimeout((int)this.connectTimeout.toMillis());
            } else {
                this.httpClientOptions.setConnectTimeout((int)DEFAULT_CONNECT_TIMEOUT);
            }
            if (this.readIdleTimeout != null) {
                this.httpClientOptions.setReadIdleTimeout((int)this.readIdleTimeout.getSeconds());
            } else {
                this.httpClientOptions.setReadIdleTimeout((int)DEFAULT_READ_TIMEOUT);
            }
            if (this.writeIdleTimeout != null) {
                this.httpClientOptions.setWriteIdleTimeout((int)this.writeIdleTimeout.getSeconds());
            } else {
                this.httpClientOptions.setWriteIdleTimeout((int)DEFAULT_WRITE_TIMEOUT);
            }
            this.httpClientOptions.setIdleTimeout((int)this.idleTimeout.getSeconds());
            Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
            ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration((Configuration)buildConfiguration, (boolean)true) : this.proxyOptions;
            if (buildProxyOptions != null) {
                String nonProxyHosts;
                ProxyOptions.Type type;
                io.vertx.core.net.ProxyOptions vertxProxyOptions = new io.vertx.core.net.ProxyOptions();
                InetSocketAddress proxyAddress = buildProxyOptions.getAddress();
                if (proxyAddress != null) {
                    vertxProxyOptions.setHost(proxyAddress.getHostName());
                    vertxProxyOptions.setPort(proxyAddress.getPort());
                }
                String proxyUsername = buildProxyOptions.getUsername();
                String proxyPassword = buildProxyOptions.getPassword();
                if (!CoreUtils.isNullOrEmpty((CharSequence)proxyUsername) && !CoreUtils.isNullOrEmpty((CharSequence)proxyPassword)) {
                    vertxProxyOptions.setUsername(proxyUsername);
                    vertxProxyOptions.setPassword(proxyPassword);
                }
                if ((type = buildProxyOptions.getType()) != null) {
                    try {
                        ProxyType proxyType = ProxyType.valueOf((String)type.name());
                        vertxProxyOptions.setType(proxyType);
                    }
                    catch (IllegalArgumentException e) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown Vert.x proxy type: " + type.name(), e));
                    }
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)(nonProxyHosts = buildProxyOptions.getNonProxyHosts()))) {
                    for (String nonProxyHost : this.desanitizedNonProxyHosts(nonProxyHosts)) {
                        this.httpClientOptions.addNonProxyHost(nonProxyHost);
                    }
                }
                this.httpClientOptions.setProxyOptions(vertxProxyOptions);
            }
        }
        io.vertx.core.http.HttpClient client = configuredVertx.createHttpClient(this.httpClientOptions);
        return new VertxAsyncHttpClient(client, configuredVertx);
    }

    private String[] desanitizedNonProxyHosts(String nonProxyHosts) {
        String desanitzedNonProxyHosts = NON_PROXY_HOST_DESANITIZE.matcher(nonProxyHosts).replaceAll("");
        desanitzedNonProxyHosts = NON_PROXY_HOST_DOT_STAR.matcher(desanitzedNonProxyHosts).replaceAll("*");
        return NON_PROXY_HOSTS_SPLIT.split(desanitzedNonProxyHosts);
    }

    private static Runnable getVertxCloseRunnable(Vertx vertxToClose) {
        return () -> {
            CountDownLatch latch = new CountDownLatch(1);
            if (vertxToClose != null) {
                vertxToClose.close(event -> {
                    if (event.failed() && event.cause() != null) {
                        LOGGER.logThrowableAsError(event.cause());
                    }
                    latch.countDown();
                });
            }
            try {
                if (!latch.await(1L, TimeUnit.MINUTES)) {
                    LOGGER.warning("Timeout closing Vertx");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
    }

    static {
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_CONNECT_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_CONNECT_TIMEOUT", (Duration)Duration.ofSeconds(10L), (ClientLogger)LOGGER).toMillis();
        DEFAULT_WRITE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_WRITE_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER).getSeconds();
        DEFAULT_READ_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)"AZURE_REQUEST_READ_TIMEOUT", (Duration)Duration.ofSeconds(60L), (ClientLogger)LOGGER).getSeconds();
    }

    private static enum DefaultVertx {
        DEFAULT_VERTX(Vertx.vertx());

        private final Vertx vertx;

        private DefaultVertx(Vertx vertx) {
            this.vertx = vertx;
            Runtime.getRuntime().addShutdownHook(new Thread(VertxAsyncHttpClientBuilder.getVertxCloseRunnable(vertx)));
        }

        private Vertx getVertx() {
            return this.vertx;
        }
    }
}

