/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.vertx.implementation.VertxHttpResponseBase;
import com.azure.core.util.FluxUtil;
import io.vertx.core.http.HttpClientResponse;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class VertxHttpAsyncResponse
extends VertxHttpResponseBase {
    public VertxHttpAsyncResponse(HttpRequest azureHttpRequest, HttpClientResponse vertxHttpResponse) {
        super(azureHttpRequest, vertxHttpResponse);
        vertxHttpResponse.pause();
    }

    public Flux<ByteBuffer> getBody() {
        return this.streamResponseBody();
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return FluxUtil.collectBytesFromNetworkResponse(this.streamResponseBody(), (HttpHeaders)this.getHeaders());
    }

    private Flux<ByteBuffer> streamResponseBody() {
        HttpClientResponse vertxHttpResponse = this.getVertxHttpResponse();
        return Flux.create(sink -> {
            vertxHttpResponse.handler(buffer -> sink.next((Object)buffer.getByteBuf().nioBuffer())).endHandler(event -> sink.complete()).exceptionHandler(arg_0 -> ((FluxSink)sink).error(arg_0));
            vertxHttpResponse.resume();
        });
    }
}

