/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientResponse;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

abstract class VertxHttpResponseBase
extends HttpResponse {
    private final HttpClientResponse vertxHttpResponse;
    private final HttpHeaders headers;

    VertxHttpResponseBase(HttpRequest azureHttpRequest, HttpClientResponse vertxHttpResponse) {
        super(azureHttpRequest);
        this.vertxHttpResponse = vertxHttpResponse;
        this.headers = this.fromVertxHttpHeaders(vertxHttpResponse.headers());
    }

    private HttpHeaders fromVertxHttpHeaders(MultiMap headers) {
        HttpHeaders azureHeaders = new HttpHeaders();
        headers.names().forEach(name -> azureHeaders.set(name, headers.getAll(name)));
        return azureHeaders;
    }

    protected HttpClientResponse getVertxHttpResponse() {
        return this.vertxHttpResponse;
    }

    public int getStatusCode() {
        return this.vertxHttpResponse.statusCode();
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue("Content-Type")));
    }

    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)charset.toString()));
    }
}

