/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.utils;

import com.azure.core.exception.AzureException;
import com.azure.identity.extensions.implementation.exception.AzureInstantiateException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ClassUtil {
    private static final Map<Class<?>, Object> DEFAULT_TYPE_VALUES;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_TO_WRAPPER_MAP;

    private ClassUtil() {
    }

    public static <R> R instantiateClass(Class<?> baseClass, Object ... constructorArguments) {
        Optional<Constructor<?>> constructor = ClassUtil.findConstructor(baseClass, constructorArguments);
        return (R)constructor.map(it -> ClassUtil.instantiateClass(it, constructorArguments)).orElseThrow(() -> new IllegalStateException(String.format("No suitable constructor found on %s to match the given arguments: %s. Make sure you implement a constructor taking these", baseClass, Arrays.stream(constructorArguments).map(Object::getClass).map(u -> ClassUtil.getQualifiedName(u)).collect(Collectors.joining(", ")))));
    }

    public static <T, P> Class<T> getClass(String className, Class<P> assignableClass) {
        if (className != null && !className.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(className);
                if (!assignableClass.isAssignableFrom(clazz)) {
                    throw new AzureException("Provided class [" + className + "] is not a [ " + assignableClass.getSimpleName() + "]");
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new AzureException("The provided class [" + className + "] can't be found", (Throwable)e);
            }
        }
        return null;
    }

    private static Optional<Constructor<?>> findConstructor(Class<?> type, Object ... constructorArguments) {
        ClassUtil.notNull(type, "Target type must not be null");
        ClassUtil.notNull(constructorArguments, "Constructor arguments must not be null");
        return Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> ClassUtil.argumentsMatch(constructor.getParameterTypes(), constructorArguments)).findFirst();
    }

    private static boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            if (argument != null && !ClassUtil.isAssignableValue(argumentType, argument)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static <T> T instantiateClass(Constructor<T> ctor, Object ... args) {
        ClassUtil.notNull(ctor, "Constructor must not be null");
        try {
            ClassUtil.makeAccessible(ctor);
            Class<?>[] parameterTypes = ctor.getParameterTypes();
            ClassUtil.isTrue(args.length <= parameterTypes.length, "Can't specify more arguments than constructor parameters");
            Object[] argsWithDefaultValues = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Class<?> parameterType;
                argsWithDefaultValues[i] = args[i] == null ? ((parameterType = parameterTypes[i]).isPrimitive() ? DEFAULT_TYPE_VALUES.get(parameterType) : null) : args[i];
            }
            return ctor.newInstance(argsWithDefaultValues);
        }
        catch (InstantiationException ex) {
            throw new AzureInstantiateException("Failed to instantiate [" + ctor.getDeclaringClass().getName() + "]: Is it an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new AzureInstantiateException("Failed to instantiate [" + ctor.getDeclaringClass().getName() + "]: Is the constructor accessible?", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new AzureInstantiateException("Failed to instantiate [" + ctor.getDeclaringClass().getName() + "]: Illegal arguments for constructor", ex);
        }
        catch (InvocationTargetException ex) {
            throw new AzureInstantiateException("Failed to instantiate [" + ctor.getDeclaringClass().getName() + "]: Constructor threw exception", ex);
        }
    }

    private static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    private static String getQualifiedName(Class<?> clazz) {
        ClassUtil.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    private static boolean isAssignableValue(Class<?> type, Object value) {
        ClassUtil.notNull(type, "Type must not be null");
        return value != null ? ClassUtil.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    private static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Objects.requireNonNull(lhsType, "Left-hand side type must not be null");
        Objects.requireNonNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        if (lhsType.isPrimitive()) {
            Class<?> resolvedWrapper = PRIMITIVE_WRAPPER_TYPE_MAP.get(rhsType);
            return lhsType == resolvedWrapper;
        }
        Class<?> resolvedWrapper = PRIMITIVE_TYPE_TO_WRAPPER_MAP.get(rhsType);
        return resolvedWrapper != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP = new HashMap();
        PRIMITIVE_TYPE_TO_WRAPPER_MAP = new HashMap();
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> values = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        values.put(Boolean.TYPE, Boolean.valueOf(false));
        values.put(Byte.TYPE, Byte.valueOf((byte)0));
        values.put(Short.TYPE, Short.valueOf((short)0));
        values.put(Integer.TYPE, Integer.valueOf(0));
        values.put(Long.TYPE, Long.valueOf(0L));
        values.put(Float.TYPE, Float.valueOf(0.0f));
        values.put(Double.TYPE, Double.valueOf(0.0));
        values.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_TYPE_VALUES = Collections.unmodifiableMap(values);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_WRAPPER_TYPE_MAP.entrySet()) {
            PRIMITIVE_TYPE_TO_WRAPPER_MAP.put(entry.getValue(), entry.getKey());
        }
    }
}

