/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Header;
import com.azure.core.util.HttpClientOptions;
import com.azure.spring.cloud.core.implementation.converter.AzureHttpLogOptionsConverter;
import com.azure.spring.cloud.core.implementation.converter.AzureHttpProxyOptionsConverter;
import com.azure.spring.cloud.core.implementation.converter.AzureHttpRetryOptionsConverter;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.http.DefaultHttpProvider;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.ClientOptionsProvider;
import com.azure.spring.cloud.core.provider.ProxyOptionsProvider;
import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureHttpClientBuilderFactory<T>
extends AbstractAzureServiceClientBuilderFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureHttpClientBuilderFactory.class);
    private final HttpClientOptions httpClientOptions = new HttpClientOptions();
    private HttpClientProvider httpClientProvider = new DefaultHttpProvider();
    private final List<HttpPipelinePolicy> httpPipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline httpPipeline;

    protected abstract BiConsumer<T, ClientOptions> consumeClientOptions();

    protected abstract BiConsumer<T, HttpClient> consumeHttpClient();

    protected abstract BiConsumer<T, HttpPipelinePolicy> consumeHttpPipelinePolicy();

    protected abstract BiConsumer<T, HttpPipeline> consumeHttpPipeline();

    protected abstract BiConsumer<T, HttpLogOptions> consumeHttpLogOptions();

    protected abstract BiConsumer<T, RetryPolicy> consumeRetryPolicy();

    @Override
    protected void configureCore(T builder) {
        super.configureCore(builder);
        this.configureHttpClient(builder);
        this.configureHttpLogOptions(builder);
    }

    protected void configureHttpClient(T builder) {
        this.consumeClientOptions().accept(builder, (ClientOptions)this.httpClientOptions);
        if (this.httpPipeline != null) {
            this.consumeHttpPipeline().accept(builder, this.httpPipeline);
        } else {
            this.configureHttpHeaders(builder);
            this.configureHttpTransportProperties(builder);
            this.configureHttpPipelinePolicies(builder);
            HttpClient httpClient = this.getHttpClientProvider().createInstance(this.httpClientOptions);
            this.consumeHttpClient().accept(builder, httpClient);
        }
    }

    @Override
    protected void configureProxy(T builder) {
        ProxyOptionsProvider.ProxyOptions proxy = this.getAzureProperties().getProxy();
        if (proxy == null) {
            return;
        }
        if (proxy instanceof ProxyOptionsProvider.HttpProxyOptions) {
            ProxyOptions proxyOptions = AzureHttpProxyOptionsConverter.HTTP_PROXY_CONVERTER.convert((ProxyOptionsProvider.HttpProxyOptions)proxy);
            if (proxyOptions != null) {
                this.httpClientOptions.setProxyOptions(proxyOptions);
            } else {
                LOGGER.debug("No HTTP proxy properties available.");
            }
        } else {
            LOGGER.debug("The provided proxy options is not a ProxyOptionsProvider.HttpProxyOptions type.");
        }
    }

    @Override
    protected BiConsumer<T, String> consumeApplicationId() {
        return (builder, id) -> this.httpClientOptions.setApplicationId(id);
    }

    protected void configureHttpHeaders(T builder) {
        this.httpClientOptions.setHeaders(this.getHeaders());
    }

    protected void configureHttpLogOptions(T builder) {
        ClientOptionsProvider.ClientOptions client = this.getAzureProperties().getClient();
        if (client == null) {
            return;
        }
        if (client instanceof ClientOptionsProvider.HttpClientOptions) {
            HttpLogOptions logOptions = AzureHttpLogOptionsConverter.HTTP_LOG_OPTIONS_CONVERTER.convert(((ClientOptionsProvider.HttpClientOptions)client).getLogging());
            this.consumeHttpLogOptions().accept(builder, logOptions);
        } else {
            LOGGER.debug("The client properties of an http-based client is of type {}", (Object)client.getClass().getName());
        }
    }

    protected void configureHttpTransportProperties(T builder) {
        ClientOptionsProvider.ClientOptions client = this.getAzureProperties().getClient();
        if (client == null) {
            return;
        }
        if (client instanceof ClientOptionsProvider.HttpClientOptions) {
            ClientOptionsProvider.HttpClientOptions properties = (ClientOptionsProvider.HttpClientOptions)client;
            this.httpClientOptions.setWriteTimeout(properties.getWriteTimeout());
            this.httpClientOptions.responseTimeout(properties.getResponseTimeout());
            this.httpClientOptions.readTimeout(properties.getReadTimeout());
            this.httpClientOptions.setConnectTimeout(properties.getConnectTimeout());
            this.httpClientOptions.setConnectionIdleTimeout(properties.getConnectionIdleTimeout());
            this.httpClientOptions.setMaximumConnectionPoolSize(properties.getMaximumConnectionPoolSize());
        }
    }

    @Override
    protected void configureRetry(T builder) {
        AzureProperties azureProperties = this.getAzureProperties();
        RetryOptionsProvider.RetryOptions retry = null;
        if (azureProperties instanceof RetryOptionsProvider) {
            retry = ((RetryOptionsProvider)((Object)azureProperties)).getRetry();
        }
        if (retry == null) {
            return;
        }
        RetryOptions retryOptions = AzureHttpRetryOptionsConverter.HTTP_RETRY_CONVERTER.convert(retry);
        if (retryOptions == null) {
            LOGGER.debug("No HTTP retry properties available.");
            return;
        }
        this.consumeRetryPolicy().accept(builder, new RetryPolicy(retryOptions));
    }

    protected void configureHttpPipelinePolicies(T builder) {
        for (HttpPipelinePolicy policy : this.httpPipelinePolicies) {
            this.consumeHttpPipelinePolicy().accept(builder, policy);
        }
    }

    protected List<Header> getHeaders() {
        ClientOptionsProvider.ClientOptions client = this.getAzureProperties().getClient();
        if (client == null) {
            return null;
        }
        if (!(client instanceof ClientOptionsProvider.HttpClientOptions)) {
            LOGGER.debug("The clientOptions passed in is not of ClientOptionsProvider.HttpClientOptions.");
            return null;
        }
        ClientOptionsProvider.HttpClientOptions clientOptions = (ClientOptionsProvider.HttpClientOptions)client;
        if (clientOptions.getHeaders() == null) {
            return null;
        }
        return clientOptions.getHeaders().stream().map(h -> new Header(h.getName(), h.getValues())).collect(Collectors.toList());
    }

    protected List<HttpPipelinePolicy> getHttpPipelinePolicies() {
        return Collections.unmodifiableList(this.httpPipelinePolicies);
    }

    public void addHttpPipelinePolicy(HttpPipelinePolicy policy) {
        this.httpPipelinePolicies.add(policy);
    }

    public void setHttpPipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
    }

    protected HttpClientProvider getHttpClientProvider() {
        return this.httpClientProvider;
    }

    protected HttpClientOptions getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public void setHttpClientProvider(HttpClientProvider httpClientProvider) {
        if (httpClientProvider != null) {
            this.httpClientProvider = httpClientProvider;
        }
    }
}

