/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.credential.AzureCredentialResolvers;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.credential.descriptor.AuthenticationDescriptor;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.AzureServiceClientBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.ClientOptionsProvider;
import com.azure.spring.cloud.core.provider.connectionstring.ConnectionStringProvider;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractAzureServiceClientBuilderFactory<T>
implements AzureServiceClientBuilderFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureServiceClientBuilderFactory.class);
    private static final TokenCredential DEFAULT_DEFAULT_TOKEN_CREDENTIAL = new DefaultAzureCredentialBuilder().build();
    private static final AzureTokenCredentialResolver DEFAULT_TOKEN_CREDENTIAL_RESOLVER = new AzureTokenCredentialResolver();
    private String springIdentifier;
    private ServiceConnectionStringProvider<?> connectionStringProvider;
    private boolean credentialConfigured = false;
    private final List<AzureServiceClientBuilderCustomizer<T>> customizers = new ArrayList<AzureServiceClientBuilderCustomizer<T>>();
    protected final Configuration configuration = new ConfigurationBuilder().build();
    protected AzureCredentialResolver<TokenCredential> tokenCredentialResolver = DEFAULT_TOKEN_CREDENTIAL_RESOLVER;
    protected TokenCredential defaultTokenCredential = DEFAULT_DEFAULT_TOKEN_CREDENTIAL;

    protected abstract T createBuilderInstance();

    protected abstract AzureProperties getAzureProperties();

    protected abstract List<AuthenticationDescriptor<?>> getAuthenticationDescriptors(T var1);

    protected abstract void configureProxy(T var1);

    protected abstract void configureRetry(T var1);

    protected abstract void configureService(T var1);

    protected abstract BiConsumer<T, String> consumeApplicationId();

    protected abstract BiConsumer<T, Configuration> consumeConfiguration();

    protected abstract BiConsumer<T, TokenCredential> consumeDefaultTokenCredential();

    protected abstract BiConsumer<T, String> consumeConnectionString();

    @Override
    public T build() {
        T builder = this.createBuilderInstance();
        this.configureCore(builder);
        this.configureService(builder);
        this.customizeBuilder(builder);
        return builder;
    }

    protected void configureCore(T builder) {
        this.configureApplicationId(builder);
        this.configureConfiguration(builder);
        this.configureRetry(builder);
        this.configureProxy(builder);
        this.configureCredential(builder);
        this.configureConnectionString(builder);
        this.configureDefaultCredential(builder);
    }

    protected void configureApplicationId(T builder) {
        String applicationId = this.getApplicationId() + (this.springIdentifier == null ? "" : this.springIdentifier);
        this.consumeApplicationId().accept(builder, applicationId);
    }

    protected void configureConfiguration(T builder) {
        this.consumeConfiguration().accept(builder, this.configuration);
    }

    protected void configureCredential(T builder) {
        List<AuthenticationDescriptor<?>> descriptors = this.getAuthenticationDescriptors(builder);
        Object azureCredential = this.resolveAzureCredential(this.getAzureProperties(), descriptors);
        if (azureCredential == null) {
            LOGGER.debug("No authentication credential configured for class {}.", (Object)builder.getClass().getSimpleName());
            return;
        }
        Consumer consumer = descriptors.stream().filter(d -> d.getAzureCredentialType().isAssignableFrom(azureCredential.getClass())).map(AuthenticationDescriptor::getConsumer).findFirst().orElseThrow(() -> new IllegalArgumentException("Consumer should not be null"));
        LOGGER.debug("Will configure the credential of type {} for {}.", (Object)azureCredential.getClass().getSimpleName(), (Object)builder.getClass().getSimpleName());
        consumer.accept(azureCredential);
        this.credentialConfigured = true;
    }

    protected void configureConnectionString(T builder) {
        String connectionString;
        AzureProperties azureProperties = this.getAzureProperties();
        if (azureProperties instanceof ConnectionStringProvider && StringUtils.hasText((String)(connectionString = ((ConnectionStringProvider)((Object)azureProperties)).getConnectionString()))) {
            this.consumeConnectionString().accept(builder, connectionString);
            this.credentialConfigured = true;
            LOGGER.debug("Connection string configured for class {}.", (Object)builder.getClass().getSimpleName());
            return;
        }
        if (this.connectionStringProvider != null && StringUtils.hasText((String)this.connectionStringProvider.getConnectionString())) {
            this.consumeConnectionString().accept(builder, this.connectionStringProvider.getConnectionString());
            this.credentialConfigured = true;
            LOGGER.debug("Connection string configured for class {}.", (Object)builder.getClass().getSimpleName());
        }
    }

    protected void configureDefaultCredential(T builder) {
        if (!this.credentialConfigured) {
            LOGGER.debug("Will configure the default credential of type {} for {}.", (Object)this.defaultTokenCredential.getClass().getSimpleName(), (Object)builder.getClass().getSimpleName());
            this.consumeDefaultTokenCredential().accept(builder, this.defaultTokenCredential);
        }
    }

    public void addBuilderCustomizer(AzureServiceClientBuilderCustomizer<T> customizer) {
        this.customizers.add(customizer);
    }

    protected List<AzureServiceClientBuilderCustomizer<T>> getBuilderCustomizers() {
        return this.customizers;
    }

    protected void customizeBuilder(T builder) {
        for (AzureServiceClientBuilderCustomizer<T> customizer : this.getBuilderCustomizers()) {
            customizer.customize(builder);
        }
    }

    private Object resolveAzureCredential(AzureProperties azureProperties, List<AuthenticationDescriptor<?>> descriptors) {
        List<AzureCredentialResolver<?>> resolvers = descriptors.stream().map(AuthenticationDescriptor::getAzureCredentialResolver).collect(Collectors.toList());
        AzureCredentialResolvers credentialResolvers = new AzureCredentialResolvers(resolvers);
        return credentialResolvers.resolve(azureProperties);
    }

    private String getApplicationId() {
        ClientOptionsProvider.ClientOptions client = this.getAzureProperties().getClient();
        return Optional.ofNullable(client).map(ClientOptionsProvider.ClientOptions::getApplicationId).orElse("");
    }

    public void setSpringIdentifier(String springIdentifier) {
        if (!StringUtils.hasText((String)springIdentifier)) {
            LOGGER.warn("SpringIdentifier is null or empty.");
            return;
        }
        this.springIdentifier = springIdentifier;
    }

    public void setDefaultTokenCredential(TokenCredential defaultTokenCredential) {
        if (defaultTokenCredential != null) {
            this.defaultTokenCredential = defaultTokenCredential;
        } else {
            LOGGER.debug("Will ignore the 'null' default token credential.");
        }
    }

    public void setConnectionStringProvider(ServiceConnectionStringProvider<?> connectionStringProvider) {
        this.connectionStringProvider = connectionStringProvider;
    }

    public void setTokenCredentialResolver(AzureCredentialResolver<TokenCredential> tokenCredentialResolver) {
        if (tokenCredentialResolver != null) {
            this.tokenCredentialResolver = tokenCredentialResolver;
        } else {
            LOGGER.debug("Will ignore the 'null' token credential resolver.");
        }
    }
}

