/*
 * Decompiled with CFR 0.152.
 */
package com.begcode.captcha.controller;

import com.begcode.captcha.model.common.ResponseModel;
import com.begcode.captcha.model.vo.CaptchaVO;
import com.begcode.captcha.service.CaptchaService;
import com.begcode.captcha.util.StringUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/captcha"})
public class CaptchaController {
    @Autowired
    private CaptchaService captchaService;

    @PostMapping(value={"/get"})
    public ResponseModel get(@RequestBody CaptchaVO data, HttpServletRequest request) {
        assert (request.getRemoteHost() != null);
        data.setBrowserInfo(CaptchaController.getRemoteId(request));
        return this.captchaService.get(data);
    }

    @PostMapping(value={"/check"})
    public ResponseModel check(@RequestBody CaptchaVO data, HttpServletRequest request) {
        data.setBrowserInfo(CaptchaController.getRemoteId(request));
        return this.captchaService.check(data);
    }

    public ResponseModel verify(@RequestBody CaptchaVO data, HttpServletRequest request) {
        return this.captchaService.verification(data);
    }

    public static final String getRemoteId(HttpServletRequest request) {
        String xfwd = request.getHeader("X-Forwarded-For");
        String ip = CaptchaController.getRemoteIpFromXfwd(xfwd);
        String ua = request.getHeader("user-agent");
        if (StringUtils.isNotBlank((String)ip)) {
            return ip + ua;
        }
        return request.getRemoteAddr() + ua;
    }

    private static String getRemoteIpFromXfwd(String xfwd) {
        if (StringUtils.isNotBlank((String)xfwd)) {
            String[] ipList = xfwd.split(",");
            return StringUtils.trim((String)ipList[0]);
        }
        return null;
    }
}

