/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.api;

import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.model.Assets;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import java.io.IOException;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsApi {
    private static final Logger log = LoggerFactory.getLogger(AssetsApi.class);

    public static Assets getAssets(String searchKey) throws IOException {
        log.debug("getAssets Call :" + searchKey);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.ASSETS) + "/?search=" + searchKey);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Assets.class);
    }

    public static Assets getAssetsWithLimit(String searchKey, String limit) throws IOException {
        log.debug("getAssetsWithLimit Call :" + searchKey + " limit " + limit);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.ASSETS) + "/?search=" + searchKey + "&limit=" + limit);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Assets.class);
    }
}

