/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.api;

import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.MetaDatas;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import java.io.IOException;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataApi {
    private static final Logger log = LoggerFactory.getLogger(MetaDataApi.class);

    public static MetaDatas getMetaData(String searchKey) throws IOException {
        log.debug("getMetaData Call :" + searchKey);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.METADATA) + "/?search=" + searchKey);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, MetaDatas.class);
    }

    public static MetaDatas getMetaDataWithLimit(String searchKey, String limit) throws IOException {
        log.debug("getMetaDataWithLimit Call :" + searchKey + " limit " + limit);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.METADATA) + "/?search=" + searchKey + "&limit=" + limit);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, MetaDatas.class);
    }
}

