/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.api;

import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.Outputs;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import java.io.IOException;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputsApi {
    private static final Logger log = LoggerFactory.getLogger(OutputsApi.class);

    public static Outputs getOutputs(String publicKey) throws IOException {
        log.debug("getOutputs Call :" + publicKey);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.OUTPUTS) + "?public_key=" + publicKey);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Outputs.class);
    }

    public static Outputs getSpentOutputs(String publicKey) throws IOException {
        log.debug("getSpentOutputs Call :" + publicKey);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.OUTPUTS) + "?public_key=" + publicKey + "&spent=true");
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Outputs.class);
    }

    public static Outputs getUnspentOutputs(String publicKey) throws IOException {
        log.debug("getUnspentOutputs Call :" + publicKey);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.OUTPUTS) + "?public_key=" + publicKey + "&spent=false");
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Outputs.class);
    }
}

