/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.builders;

import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.model.ApiEndpoints;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import com.bigchaindb.ws.BigchainDbWSSessionManager;
import com.bigchaindb.ws.MessageHandler;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigchainDbConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(BigchainDbConfigBuilder.class);

    private BigchainDbConfigBuilder() {
    }

    public static ITokens baseUrl(String baseUrl) {
        return new Builder(baseUrl);
    }

    private static class Builder
    implements ITokens {
        String baserUrl;
        Map<String, String> tokens = new HashMap<String, String>();
        OkHttpClient httpClient;
        boolean setupWsockets = false;
        MessageHandler messageHandler = null;
        private Interceptor authInterceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                if (tokens == null) {
                    return chain.proceed(originalRequest);
                }
                Request.Builder authorisedRequest = originalRequest.newBuilder();
                for (String key : tokens.keySet()) {
                    authorisedRequest = authorisedRequest.addHeader(key, tokens.get(key));
                }
                return chain.proceed(authorisedRequest.build());
            }
        };

        public Builder(String baseUrl) {
            this.baserUrl = baseUrl;
        }

        @Override
        public ITokens addToken(String key, String value) {
            this.tokens.put(key, value);
            return this;
        }

        @Override
        public void setup() {
            log.debug(this.baserUrl);
            BigChainDBGlobals.setAuthorizationTokens(this.tokens);
            BigChainDBGlobals.setBaseUrl(this.baserUrl + "/api" + (Object)((Object)BigchainDbApi.API_VERSION));
            BigChainDBGlobals.setWsSocketUrl(this.baserUrl + "/api" + (Object)((Object)BigchainDbApi.API_VERSION) + (Object)((Object)BigchainDbApi.STREAMS));
            if (this.httpClient == null && BigChainDBGlobals.getHttpClient() == null) {
                BigChainDBGlobals.setHttpClient(this.buildDefaultHttpClient());
            }
            try {
                BigChainDBGlobals.setApiEndpoints(JsonUtils.fromJson(NetworkUtils.sendGetRequest(this.baserUrl + "/api" + (Object)((Object)BigchainDbApi.API_VERSION)).body().string(), ApiEndpoints.class));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.setupWsockets) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        new BigchainDbWSSessionManager(URI.create(BigChainDBGlobals.getApiEndpoints().getStreams()), messageHandler);
                    }
                }).start();
            }
        }

        private OkHttpClient buildDefaultHttpClient() {
            return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).addInterceptor(this.authInterceptor).build();
        }

        @Override
        public ITokens webSocketMonitor(MessageHandler messageHandler) {
            this.setupWsockets = true;
            this.messageHandler = messageHandler;
            return this;
        }
    }

    public static interface ITokens {
        public ITokens addToken(String var1, String var2);

        public ITokens webSocketMonitor(MessageHandler var1);

        public void setup();
    }
}

