/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.json.factory;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class GsonEmptyCheckTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (Map.class.isAssignableFrom(type.getRawType())) {
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            return new EmptyCheckTypeAdapter(delegate, (TypeAdapter<JsonElement>)elementAdapter).nullSafe();
        }
        return null;
    }

    public static class EmptyCheckTypeAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> delegate;
        private final TypeAdapter<JsonElement> elementAdapter;

        public EmptyCheckTypeAdapter(TypeAdapter<T> delegate, TypeAdapter<JsonElement> elementAdapter) {
            this.delegate = delegate;
            this.elementAdapter = elementAdapter;
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.delegate.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            JsonObject asJsonObject = ((JsonElement)this.elementAdapter.read(in)).getAsJsonObject();
            if (asJsonObject.entrySet().isEmpty()) {
                return null;
            }
            return (T)this.delegate.fromJsonTree((JsonElement)asJsonObject);
        }
    }
}

