/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.util;

public class Base58 {
    private static final char[] ALPHABET;
    private static final int BASE_58;
    private static final int BASE_256 = 256;
    private static final int[] INDEXES;

    public static String encode(byte[] input) {
        int zeroCount;
        if (input.length == 0) {
            return "";
        }
        input = Base58.copyOfRange(input, 0, input.length);
        for (zeroCount = 0; zeroCount < input.length && input[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input.length) {
            byte mod = Base58.divmod58(input, startAt);
            if (input[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        byte[] output = Base58.copyOfRange(temp, j, temp.length);
        return new String(output);
    }

    private static byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / BASE_58);
            remainder = temp % BASE_58;
        }
        return (byte)remainder;
    }

    private static byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    static {
        int i;
        ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        BASE_58 = ALPHABET.length;
        INDEXES = new int[128];
        for (i = 0; i < INDEXES.length; ++i) {
            Base58.INDEXES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

