/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import org.bouncycastle.jcajce.provider.digest.SHA3;

public class DriverUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getHex(byte[] data) {
        int l = data.length;
        char[] outData = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            outData[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            outData[j++] = DIGITS[0xF & data[i]];
        }
        return new String(outData);
    }

    public static JsonObject makeSelfSortingGson(String input) {
        if (input == null) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        return DriverUtils.makeSelfSortingGson(jsonParser.parse(input).getAsJsonObject());
    }

    public static JsonObject makeSelfSortingGson(JsonObject input) {
        if (input == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        ArrayList keys = new ArrayList(input.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            JsonElement j = input.get(key);
            if (j instanceof JsonObject) {
                json.add(key, (JsonElement)DriverUtils.makeSelfSortingGson((JsonObject)j));
                continue;
            }
            if (j instanceof JsonArray) {
                JsonArray h = (JsonArray)j;
                JsonArray oList = new JsonArray();
                for (int i = 0; i < h.size(); ++i) {
                    JsonElement joi = h.get(i);
                    if (joi instanceof JsonObject) {
                        oList.add((JsonElement)DriverUtils.makeSelfSortingGson((JsonObject)joi));
                        json.add(key, (JsonElement)oList);
                        continue;
                    }
                    oList.add(joi);
                    json.add(key, (JsonElement)oList);
                }
                continue;
            }
            json.add(key, j);
        }
        return json;
    }

    public static byte[] getSha3HashRaw(byte[] input) {
        SHA3.DigestSHA3 md = new SHA3.DigestSHA3(256);
        md.update(input);
        return md.digest();
    }

    public static String getSha3HashHex(byte[] input) {
        SHA3.DigestSHA3 md = new SHA3.DigestSHA3(256);
        md.update(input);
        String id = DriverUtils.getHex(md.digest());
        return id;
    }
}

