/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.util;

import com.bigchaindb.json.factory.GsonEmptyCheckTypeAdapterFactory;
import com.bigchaindb.json.strategy.AssetSerializer;
import com.bigchaindb.json.strategy.AssetsDeserializer;
import com.bigchaindb.json.strategy.CustomExclusionStrategy;
import com.bigchaindb.json.strategy.MetaDataDeserializer;
import com.bigchaindb.json.strategy.MetaDataSerializer;
import com.bigchaindb.json.strategy.OutputsDeserializer;
import com.bigchaindb.json.strategy.TransactionDeserializer;
import com.bigchaindb.json.strategy.TransactionsDeserializer;
import com.bigchaindb.json.strategy.ValidatorDeserializer;
import com.bigchaindb.model.Asset;
import com.bigchaindb.model.Assets;
import com.bigchaindb.model.MetaData;
import com.bigchaindb.model.MetaDatas;
import com.bigchaindb.model.Outputs;
import com.bigchaindb.model.Transaction;
import com.bigchaindb.model.Transactions;
import com.bigchaindb.model.Validators;
import com.bigchaindb.util.TypeAdapter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonUtils {
    private static String jsonDateFormat = "yyyy-MM-dd'T'HH:mm:ssZZZZZ";
    private static Map<String, TypeAdapter> typeAdaptersDeserialize = new ConcurrentHashMap<String, TypeAdapter>(16){
        {
            this.put(Transaction.class.getCanonicalName(), new TypeAdapter(Transaction.class, new TransactionDeserializer()));
            this.put(Transactions.class.getCanonicalName(), new TypeAdapter(Transactions.class, new TransactionsDeserializer()));
            this.put(Assets.class.getCanonicalName(), new TypeAdapter(Assets.class, new AssetsDeserializer()));
            this.put(MetaDatas.class.getCanonicalName(), new TypeAdapter(MetaDatas.class, new MetaDataDeserializer()));
            this.put(Outputs.class.getCanonicalName(), new TypeAdapter(Outputs.class, new OutputsDeserializer()));
            this.put(Validators.class.getCanonicalName(), new TypeAdapter(Validators.class, new ValidatorDeserializer()));
        }
    };
    private static Map<String, TypeAdapter> typeAdaptersSerialize = new ConcurrentHashMap<String, TypeAdapter>(16){
        {
            this.put(Asset.class.getCanonicalName(), new TypeAdapter(Asset.class, new AssetSerializer()));
            this.put(MetaData.class.getCanonicalName(), new TypeAdapter(MetaData.class, new MetaDataSerializer()));
        }
    };

    private static synchronized GsonBuilder base() {
        GsonBuilder builder = new GsonBuilder();
        builder = builder.serializeNulls().disableHtmlEscaping().setDateFormat(jsonDateFormat).registerTypeAdapterFactory((TypeAdapterFactory)new GsonEmptyCheckTypeAdapterFactory()).addSerializationExclusionStrategy((ExclusionStrategy)new CustomExclusionStrategy());
        return builder;
    }

    public static Gson getGson() {
        GsonBuilder builder = JsonUtils.base();
        for (TypeAdapter adapter : typeAdaptersDeserialize.values()) {
            builder.registerTypeAdapter((Type)adapter.getType(), adapter.getSerializer());
        }
        for (TypeAdapter adapter : typeAdaptersSerialize.values()) {
            builder.registerTypeAdapter((Type)adapter.getType(), adapter.getSerializer());
        }
        return builder.create();
    }

    public static Gson getGson(ExclusionStrategy ... exclusionStrategies) {
        return JsonUtils.getGson(null, exclusionStrategies);
    }

    public static Gson getGson(Class ignoreClass, ExclusionStrategy ... exclusionStrategies) {
        GsonBuilder builder = JsonUtils.base();
        for (TypeAdapter adapter : typeAdaptersDeserialize.values()) {
            if (adapter.getType().equals(ignoreClass)) continue;
            builder.registerTypeAdapter((Type)adapter.getType(), adapter.getSerializer());
        }
        for (TypeAdapter adapter : typeAdaptersSerialize.values()) {
            if (adapter.getType().equals(ignoreClass)) continue;
            builder.registerTypeAdapter((Type)adapter.getType(), adapter.getSerializer());
        }
        return builder.setExclusionStrategies(exclusionStrategies).create();
    }

    public static void addTypeAdapterDeserializer(Class type, JsonDeserializer<?> jsonDeserializer) {
        typeAdaptersDeserialize.put(type.getCanonicalName(), new TypeAdapter(type, jsonDeserializer));
    }

    public static void addTypeAdapterSerializer(Class type, JsonSerializer<?> jsonSerializer) {
        typeAdaptersSerialize.put(type.getCanonicalName(), new TypeAdapter(type, jsonSerializer));
    }

    public static <T> T fromJson(String json, Class<T> T) {
        return (T)JsonUtils.getGson().fromJson(json, T);
    }

    public static String toJson(Object src) {
        return JsonUtils.getGson().toJson(src);
    }

    public static String toJson(Object src, ExclusionStrategy ... exclusionStrategies) {
        return JsonUtils.getGson(exclusionStrategies).toJson(src);
    }

    public static void setJsonDateFormat(String dateFormat) {
        jsonDateFormat = dateFormat;
    }
}

