/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.util;

import com.bigchaindb.util.Base58;
import com.google.api.client.util.Base64;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class KeyPairUtils {
    public static KeyPair generateNewKeyPair() {
        KeyPairGenerator edDsaKpg = new KeyPairGenerator();
        return edDsaKpg.generateKeyPair();
    }

    public static String encodePublicKeyInBase58(EdDSAPublicKey publicKey) {
        return Base58.encode(Arrays.copyOfRange(publicKey.getEncoded(), 12, 44));
    }

    public static byte[] encodePrivateKey(KeyPair keyPair) {
        return keyPair.getPrivate().getEncoded();
    }

    public static String encodePrivateKeyBase64(KeyPair keyPair) {
        return Base64.encodeBase64String((byte[])KeyPairUtils.encodePrivateKey(keyPair));
    }

    public static KeyPair decodeKeyPair(byte[] encodedPrivateKey) {
        EdDSANamedCurveSpec keySpecs = EdDSANamedCurveTable.getByName((String)"Ed25519");
        byte[] seed = Arrays.copyOfRange(encodedPrivateKey, 16, 48);
        EdDSAPrivateKeySpec privKeySpec = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)keySpecs);
        EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(privKeySpec.getA(), (EdDSAParameterSpec)keySpecs);
        return new KeyPair((PublicKey)new EdDSAPublicKey(pubKeySpec), (PrivateKey)new EdDSAPrivateKey(privKeySpec));
    }

    public static KeyPair decodeKeyPair(String encodedPrivateKeyBase64) {
        return KeyPairUtils.decodeKeyPair(Base64.decodeBase64((String)encodedPrivateKeyBase64));
    }
}

