/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.util;

import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.GenericCallback;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NetworkUtils {
    public static void sendPostRequest(String url, RequestBody body, final GenericCallback callback) {
        Request request = new Request.Builder().url(url).post(body).build();
        BigChainDBGlobals.getHttpClient().newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) {
                if (response.code() == 202) {
                    callback.pushedSuccessfully(response);
                } else if (response.code() == 400) {
                    callback.transactionMalformed(response);
                } else {
                    callback.otherError(response);
                }
                response.close();
            }
        });
    }

    public static Response sendPostRequest(String url, RequestBody body) throws IOException {
        Request request = new Request.Builder().url(url).post(body).build();
        return BigChainDBGlobals.getHttpClient().newCall(request).execute();
    }

    public static Response sendGetRequest(String url) throws IOException {
        Request request = new Request.Builder().url(url).get().build();
        return BigChainDBGlobals.getHttpClient().newCall(request).execute();
    }
}

