/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.ws;

import com.bigchaindb.util.ScannerUtil;
import com.bigchaindb.ws.MessageHandler;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class BigchainDbWSSessionManager {
    private static final Logger log = LoggerFactory.getLogger(BigchainDbWSSessionManager.class);
    private Session userSession = null;
    private MessageHandler messageHandler;

    public BigchainDbWSSessionManager(URI endpointURI, MessageHandler messageHandler) {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.setDefaultMaxSessionIdleTimeout(-1L);
            this.messageHandler = messageHandler;
            container.connectToServer((Object)this, endpointURI);
            ScannerUtil.monitorExit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OnOpen
    public void onOpen(Session userSession) {
        log.debug("Opening Websocket");
        this.userSession = userSession;
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        log.debug("Closing Websocket");
        this.userSession = null;
    }

    @OnMessage
    public void onMessage(String message) {
        log.debug(message);
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(message);
        }
    }

    public void addMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        this.userSession.getAsyncRemote().sendText(message);
    }
}

