/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence;

import com.blazebit.persistence.DefaultPackageOpener;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.spi.CriteriaBuilderConfigurationProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public class Criteria {
    private static volatile CriteriaBuilderConfigurationProvider cachedDefaultProvider;

    private Criteria() {
    }

    public static CriteriaBuilderConfigurationProvider getDefaultProvider() {
        CriteriaBuilderConfigurationProvider cachedDefaultProvider = Criteria.cachedDefaultProvider;
        if (cachedDefaultProvider == null) {
            ServiceLoader<CriteriaBuilderConfigurationProvider> serviceLoader = ServiceLoader.load(CriteriaBuilderConfigurationProvider.class);
            Iterator<CriteriaBuilderConfigurationProvider> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                Criteria.cachedDefaultProvider = iterator.next();
                return Criteria.cachedDefaultProvider;
            }
            throw new IllegalStateException("No CriteriaBuilderConfigurationProvider found on the class path. Please check if a valid implementation is on the class path.");
        }
        return cachedDefaultProvider;
    }

    public static CriteriaBuilderConfiguration getDefault() {
        return Criteria.getDefaultProvider().createConfiguration(DefaultPackageOpener.INSTANCE);
    }
}

