/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console;

import com.bstek.ureport.console.ServletAction;
import com.bstek.ureport.exception.ReportComputeException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseServletAction
implements ServletAction {
    protected String decode(String value) {
        try {
            value = URLDecoder.decode(value, "utf-8");
            value = URLDecoder.decode(value, "utf-8");
            return value;
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
    }

    protected Map<String, Object> buildParameters(HttpServletRequest req) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj == null) continue;
            String name = obj.toString();
            String value = req.getParameter(name);
            if (name == null || value == null || name.startsWith("_")) continue;
            parameters.put(name, this.decode(value));
        }
        return parameters;
    }

    protected void invokeMethod(String methodName, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            Method method = this.getClass().getMethod(methodName, HttpServletRequest.class, HttpServletResponse.class);
            method.invoke((Object)this, req, resp);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected String retriveMethod(HttpServletRequest req) throws ServletException {
        String path = String.valueOf(req.getContextPath()) + "/ureport";
        String uri = req.getRequestURI();
        String targetUrl = uri.substring(path.length());
        int slashPos = targetUrl.indexOf("/", 1);
        if (slashPos > -1) {
            String methodName = targetUrl.substring(slashPos + 1).trim();
            return methodName.length() > 0 ? methodName : null;
        }
        return null;
    }
}

