/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseDeferredValue;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.stream.AbstractByteArrayInputStream;
import com.clickhouse.client.stream.BlockingInputStream;
import com.clickhouse.client.stream.DeferredInputStream;
import com.clickhouse.client.stream.EmptyInputStream;
import com.clickhouse.client.stream.IterableByteArrayInputStream;
import com.clickhouse.client.stream.IterableByteBufferInputStream;
import com.clickhouse.client.stream.IterableMultipleInputStream;
import com.clickhouse.client.stream.IterableObjectInputStream;
import com.clickhouse.client.stream.Lz4InputStream;
import com.clickhouse.client.stream.WrappedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

public abstract class ClickHouseInputStream
extends InputStream {
    @Deprecated
    public static final byte[] EMPTY_BYTES = ClickHouseByteBuffer.EMPTY_BYTES;
    @Deprecated
    public static final ByteBuffer EMPTY_BUFFER = ClickHouseByteBuffer.EMPTY_BUFFER;
    protected static final String ERROR_INCOMPLETE_READ = "Reached end of input stream after reading %d of %d bytes";
    protected static final String ERROR_NULL_BYTES = "Non-null byte array is required";
    protected static final String ERROR_REUSE_BUFFER = "Please pass a different byte array instead of the same internal buffer for reading";
    protected static final String ERROR_STREAM_CLOSED = "Input stream has been closed";
    protected final ClickHouseByteBuffer byteBuffer = ClickHouseByteBuffer.newInstance();
    protected final ClickHouseFile file;
    protected final Runnable postCloseAction;
    protected boolean closed;
    protected OutputStream copyTo;

    static ClickHouseInputStream wrap(ClickHouseFile file, InputStream input, int bufferSize, Runnable postCloseAction, ClickHouseCompression compression, int compressionLevel) {
        AbstractByteArrayInputStream chInput;
        if (compression == null || compression == ClickHouseCompression.NONE) {
            chInput = new WrappedInputStream(file, input, bufferSize, postCloseAction);
        } else {
            switch (compression) {
                case GZIP: {
                    try {
                        chInput = new WrappedInputStream(file, new GZIPInputStream(input), bufferSize, postCloseAction);
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to wrap input stream", e);
                    }
                }
                case LZ4: {
                    chInput = new Lz4InputStream(file, input, postCloseAction);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported compression algorithm: " + (Object)((Object)compression));
                }
            }
        }
        return chInput;
    }

    public static ClickHouseInputStream empty() {
        return EmptyInputStream.INSTANCE;
    }

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout) {
        return ClickHouseInputStream.of(queue, timeout, null);
    }

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout, Runnable postCloseAction) {
        return new BlockingInputStream(queue, timeout, postCloseAction);
    }

    public static ClickHouseInputStream of(ClickHouseDeferredValue<InputStream> deferredInput, int bufferSize, Runnable postCloseAction) {
        return new WrappedInputStream(null, new DeferredInputStream(deferredInput), bufferSize, postCloseAction);
    }

    public static ClickHouseInputStream of(ClickHouseFile file, int bufferSize, Runnable postCloseAction) {
        if (file == null || !file.isAvailable()) {
            throw new IllegalArgumentException("Non-null file required");
        }
        try {
            return ClickHouseInputStream.wrap(file, new FileInputStream(file.getFile()), bufferSize, postCloseAction, file.getCompressionAlgorithm(), file.getCompressionLevel());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize) {
        return ClickHouseInputStream.of(input, bufferSize, null, null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize, Runnable postCloseAction) {
        return ClickHouseInputStream.of(input, bufferSize, null, postCloseAction);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize, ClickHouseCompression compression) {
        return ClickHouseInputStream.of(input, bufferSize, compression, null);
    }

    public static ClickHouseInputStream of(InputStream input, int bufferSize, ClickHouseCompression compression, Runnable postCloseAction) {
        if (input == null) {
            return EmptyInputStream.INSTANCE;
        }
        if (input != EmptyInputStream.INSTANCE && input instanceof ClickHouseInputStream) {
            return (ClickHouseInputStream)input;
        }
        return ClickHouseInputStream.wrap(null, input, bufferSize, postCloseAction, compression, 0);
    }

    public static ClickHouseInputStream of(byte[] ... bytes) {
        if (bytes == null || bytes.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return new IterableByteArrayInputStream(Arrays.asList(bytes), null);
    }

    public static ClickHouseInputStream of(ByteBuffer ... buffers) {
        if (buffers == null || buffers.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return new IterableByteBufferInputStream(Arrays.asList(buffers), null);
    }

    public static ClickHouseInputStream of(File ... files) {
        if (files == null || files.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(files), File.class, null, null);
    }

    public static ClickHouseInputStream of(InputStream ... inputs) {
        if (inputs == null || inputs.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        if (inputs.length == 1) {
            return ClickHouseInputStream.of(inputs[0], (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue(), null, null);
        }
        return ClickHouseInputStream.of(Arrays.asList(inputs), InputStream.class, null, null);
    }

    public static ClickHouseInputStream of(String ... strings) {
        if (strings == null || strings.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(strings), String.class, null, null);
    }

    public static ClickHouseInputStream of(URL ... urls) {
        if (urls == null || urls.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(urls), URL.class, null, null);
    }

    public static <T> ClickHouseInputStream of(T[] source, Class<T> clazz, Function<T, byte[]> converter, Runnable postCloseAction) {
        if (source == null || source.length == 0) {
            return EmptyInputStream.INSTANCE;
        }
        return ClickHouseInputStream.of(Arrays.asList(source), clazz, converter, postCloseAction);
    }

    public static <T> ClickHouseInputStream of(Iterable<T> source, Class<T> clazz, Function<T, byte[]> converter, Runnable postCloseAction) {
        if (source == null) {
            return EmptyInputStream.INSTANCE;
        }
        if (converter != null) {
            return new IterableObjectInputStream<T>(source, converter, postCloseAction);
        }
        if (clazz == byte[].class) {
            return new IterableByteArrayInputStream(source, postCloseAction);
        }
        if (clazz == ByteBuffer.class) {
            return new IterableByteBufferInputStream(source, postCloseAction);
        }
        if (clazz == File.class) {
            return new IterableMultipleInputStream<File>(source, f -> {
                if (f == null) {
                    return null;
                }
                try {
                    return new FileInputStream((File)f);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }, postCloseAction);
        }
        if (clazz == String.class) {
            return new IterableObjectInputStream<String>(source, s -> s == null || s.isEmpty() ? ClickHouseByteBuffer.EMPTY_BYTES : s.getBytes(StandardCharsets.UTF_8), postCloseAction);
        }
        if (clazz == URL.class) {
            return new IterableMultipleInputStream<URL>(source, u -> {
                if (u == null) {
                    return null;
                }
                try {
                    return u.openStream();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }, postCloseAction);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return new IterableMultipleInputStream<InputStream>(source, i -> i, postCloseAction);
        }
        throw new IllegalArgumentException("Missing converter for data type: " + clazz);
    }

    public static long pipe(InputStream input, OutputStream output, int bufferSize) throws IOException {
        if (input instanceof ClickHouseInputStream && output instanceof ClickHouseOutputStream) {
            return ((ClickHouseInputStream)input).pipe((ClickHouseOutputStream)output);
        }
        bufferSize = ClickHouseUtils.getBufferSize(bufferSize, (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue(), (Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue());
        return ClickHouseInputStream.pipe(input, output, new byte[bufferSize]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long pipe(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        if (buffer == null && input instanceof ClickHouseInputStream && output instanceof ClickHouseOutputStream) {
            return ((ClickHouseInputStream)input).pipe((ClickHouseOutputStream)output);
        }
        if (input == null || output == null || buffer == null || buffer.length < 1) {
            throw new IllegalArgumentException("Non-null input, output, and write buffer are required");
        }
        int size = buffer.length;
        long count = 0L;
        int written = 0;
        try {
            while ((written = input.read(buffer, 0, size)) >= 0) {
                output.write(buffer, 0, written);
                count += (long)written;
            }
            input.close();
            input = null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        return count;
    }

    public static File save(InputStream in, int bufferSize, int timeout) {
        return ClickHouseInputStream.save(null, in, bufferSize, timeout, true);
    }

    public static File save(File file, InputStream in, int bufferSize, int timeout, boolean deleteOnExit) {
        File tmp;
        if (file != null) {
            tmp = file;
            if (deleteOnExit) {
                tmp.deleteOnExit();
            }
        } else {
            try {
                tmp = File.createTempFile("chc", "data");
                tmp.deleteOnExit();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp file", e);
            }
        }
        CompletableFuture<File> data = CompletableFuture.supplyAsync(() -> {
            try {
                try (FileOutputStream out = new FileOutputStream(tmp);){
                    ClickHouseInputStream.pipe(in, (OutputStream)out, bufferSize);
                }
                return tmp;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        try {
            return data.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UncheckedIOException) {
                cause = ((UncheckedIOException)cause).getCause();
            }
            throw new IllegalStateException(cause);
        }
    }

    protected ClickHouseInputStream(ClickHouseFile file, OutputStream copyTo, Runnable postCloseAction) {
        this.file = file != null ? file : ClickHouseFile.NULL;
        this.postCloseAction = postCloseAction;
        this.closed = false;
        this.copyTo = copyTo;
    }

    protected void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(ERROR_STREAM_CLOSED);
        }
    }

    public ClickHouseFile getUnderlyingFile() {
        return this.file;
    }

    public abstract int peek() throws IOException;

    public abstract long pipe(ClickHouseOutputStream var1) throws IOException;

    public int readUnsignedByte() throws IOException {
        return 0xFF & this.readByte();
    }

    public ClickHouseByteBuffer readBuffer(int length) throws IOException {
        if (length < 1) {
            return this.byteBuffer.reset();
        }
        return this.byteBuffer.update(this.readBytes(length));
    }

    public abstract byte readByte() throws IOException;

    public byte[] readBytes(int length) throws IOException {
        int read;
        if (length < 1) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        this.ensureOpen();
        byte[] bytes = new byte[length];
        for (int offset = 0; offset < length; offset += read) {
            read = this.read(bytes, offset, length - offset);
            if (read != -1) continue;
            this.closeQuietly();
            throw offset == 0 ? new EOFException() : new IOException(ClickHouseUtils.format(ERROR_INCOMPLETE_READ, offset, length));
        }
        return bytes;
    }

    public abstract ClickHouseByteBuffer readCustom(ClickHouseDataUpdater var1) throws IOException;

    public String readString(Charset charset) throws IOException {
        return this.readString(this.readVarInt(), charset);
    }

    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        return this.readBuffer(byteLength).asString(charset);
    }

    public String readAsciiString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.US_ASCII);
    }

    public String readAsciiString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.US_ASCII);
    }

    public String readUnicodeString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.UTF_8);
    }

    public String readUnicodeString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.UTF_8);
    }

    public int readVarInt() throws IOException {
        int shift;
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int result = b & 0x7F;
        for (shift = 7; shift <= 28; shift += 7) {
            b = this.readByte();
            if (b >= 0) {
                result |= b << shift;
                break;
            }
            result |= (b & 0x7F) << shift;
        }
        if (b < 0) {
            for (shift = 35; shift <= 63 && this.peek() >= 0 && this.readByte() < 0; shift += 7) {
            }
        }
        return result;
    }

    public long readVarLong() throws IOException {
        long b = this.readByte();
        if (b >= 0L) {
            return b;
        }
        long result = b & 0x7FL;
        for (int shift = 7; shift <= 63; shift += 7) {
            b = this.readByte();
            if (b >= 0L) {
                result |= b << shift;
                break;
            }
            result |= (b & 0x7FL) << shift;
        }
        return result;
    }

    public final void setCopyToTarget(OutputStream out) throws IOException {
        if (this.copyTo != null) {
            this.copyTo.flush();
        } else if (out != null) {
            this.readCustom((b, p, l) -> {
                if (p < l) {
                    out.write(b, p, l - p);
                }
                return 0;
            });
        }
        this.copyTo = out;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.byteBuffer.reset();
            if (this.postCloseAction != null) {
                this.postCloseAction.run();
            }
        }
    }
}

