/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class ClickHouseInputStream
extends InputStream {
    public static final ByteBuffer EMPTY = ByteBuffer.wrap(new byte[0]).asReadOnlyBuffer();

    public static ClickHouseInputStream of(BlockingQueue<ByteBuffer> queue, int timeout) {
        return new BlockingInputStream(ClickHouseChecker.nonNull(queue, "queue"), timeout);
    }

    public static ClickHouseInputStream of(InputStream input) {
        return input instanceof ClickHouseInputStream ? (ClickHouseInputStream)input : new WrappedInputStream(input);
    }

    public int readUnsignedByte() throws IOException {
        return 0xFF & this.readByte();
    }

    public abstract byte readByte() throws IOException;

    public byte[] readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        int c = 0;
        int n = 0;
        for (int l = length; l > 0; l -= n) {
            n = this.read(bytes, c, l);
            if (n != -1) {
                c += n;
                continue;
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw c == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", c, length));
        }
        return bytes;
    }

    public String readString(Charset charset) throws IOException {
        return this.readString(this.readVarInt(), charset);
    }

    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        return new String(this.readBytes(byteLength), charset != null ? charset : StandardCharsets.UTF_8);
    }

    public String readAsciiString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.US_ASCII);
    }

    public String readAsciiString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.US_ASCII);
    }

    public String readUnicodeString() throws IOException {
        return this.readString(this.readVarInt(), StandardCharsets.UTF_8);
    }

    public String readUnicodeString(int byteLength) throws IOException {
        return this.readString(byteLength, StandardCharsets.UTF_8);
    }

    public int readVarInt() throws IOException {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            byte b = this.readByte();
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public abstract boolean isClosed();

    static final class WrappedInputStream
    extends ClickHouseInputStream {
        private final InputStream in;
        private boolean closed;

        WrappedInputStream(InputStream input) {
            this.in = ClickHouseChecker.nonNull(input, "InputStream");
            this.closed = false;
        }

        @Override
        public int available() throws IOException {
            return !this.closed ? this.in.available() : 0;
        }

        @Override
        public byte readByte() throws IOException {
            int v = this.in.read();
            if (v == -1) {
                this.close();
                throw new EOFException();
            }
            return (byte)v;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            try {
                this.in.close();
            }
            finally {
                this.closed = true;
            }
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }

    static final class BlockingInputStream
    extends ClickHouseInputStream {
        private final BlockingQueue<ByteBuffer> queue;
        private final int timeout;
        private ByteBuffer buffer;
        private boolean closed;

        BlockingInputStream(BlockingQueue<ByteBuffer> queue, int timeout) {
            this.queue = queue;
            this.timeout = timeout;
            this.buffer = null;
            this.closed = false;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream has been closed");
            }
            if (this.buffer == null || this.buffer != EMPTY && !this.buffer.hasRemaining()) {
                this.updateBuffer();
            }
        }

        private int updateBuffer() throws IOException {
            try {
                if (this.timeout > 0) {
                    this.buffer = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                    if (this.buffer == null) {
                        throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", this.timeout));
                    }
                } else {
                    this.buffer = this.queue.take();
                }
                return this.buffer.remaining();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when getting next buffer from queue", e);
            }
        }

        @Override
        public int available() throws IOException {
            this.ensureOpen();
            return this.buffer.remaining();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.buffer = null;
        }

        @Override
        public byte readByte() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY) {
                this.close();
                throw new EOFException();
            }
            return this.buffer.get();
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY) {
                return -1;
            }
            return 0xFF & this.buffer.get();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            int counter = 0;
            while (len > 0) {
                if (this.buffer == EMPTY) {
                    return counter > 0 ? counter : -1;
                }
                int remain = this.buffer.remaining();
                if (remain >= len) {
                    this.buffer.get(b, off, len);
                    counter += len;
                    len = 0;
                    continue;
                }
                this.buffer.get(b, off, remain);
                counter += remain;
                off += remain;
                len -= remain;
                this.updateBuffer();
            }
            return counter;
        }

        @Override
        public String readString(int byteLength, Charset charset) throws IOException {
            this.ensureOpen();
            if (byteLength < 1) {
                return "";
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            if (!this.buffer.isReadOnly() && byteLength > 8 && this.buffer.remaining() > byteLength) {
                int pos = this.buffer.position();
                ((Buffer)this.buffer).position(pos + byteLength);
                return charset.decode(ByteBuffer.wrap(this.buffer.array(), pos, byteLength)).toString();
            }
            return new String(this.readBytes(byteLength), charset);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            if (n == Long.MAX_VALUE) {
                long counter = this.buffer.remaining();
                while (this.buffer != EMPTY && this.buffer.limit() > 0) {
                    counter += (long)this.buffer.limit();
                    this.updateBuffer();
                }
                return counter;
            }
            return super.skip(n);
        }
    }
}

