/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.boxes.FullBox;
import java.awt.Point;
import java.io.IOException;

public class TrackHeaderBox
extends FullBox {
    long creationTime;
    long modificationTime;
    long trackID;
    long duration;
    int layer;
    int alternateGroup;
    int volume;
    int[] matrix = new int[9];
    long width;
    long height;

    public TrackHeaderBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        if (this.version == 1) {
            this.creationTime = reader.getInt64();
            this.modificationTime = reader.getInt64();
            this.trackID = reader.getInt32();
            reader.skip(4L);
            this.duration = reader.getInt64();
        } else {
            this.creationTime = reader.getUInt32();
            this.modificationTime = reader.getUInt32();
            this.trackID = reader.getUInt32();
            reader.skip(4L);
            this.duration = reader.getUInt32();
        }
        reader.skip(8L);
        this.layer = reader.getInt16();
        this.alternateGroup = reader.getInt16();
        this.volume = reader.getInt16();
        reader.skip(2L);
        for (int i = 0; i < 9; ++i) {
            this.matrix[i] = reader.getInt32();
        }
        this.width = reader.getInt32();
        this.height = reader.getInt32();
    }

    public void addMetadata(Mp4Directory directory) {
        if (this.width != 0L && this.height != 0L && directory.getDoubleObject(512) == null) {
            Point p = new Point(this.matrix[1] + this.matrix[4], this.matrix[0] + this.matrix[3]);
            double theta = Math.atan2(p.y, p.x);
            double degree = Math.toDegrees(theta);
            directory.setDouble(512, Math.abs(degree -= 45.0));
        }
    }
}

