/*
 * Copyright 2013 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.api.client.googleapis.testing.notifications;

import com.google.api.client.googleapis.notifications.StoredChannel;
import com.google.api.client.googleapis.notifications.UnparsedNotification;
import com.google.api.client.googleapis.notifications.UnparsedNotificationCallback;
import com.google.api.client.util.Beta;
import java.io.IOException;

/**
 * {@link Beta} <br>
 * Mock for the {@link UnparsedNotificationCallback} class.
 *
 * @author Yaniv Inbar
 * @author Matthias Linder (mlinder)
 * @since 1.16
 */
@SuppressWarnings("rawtypes")
@Beta
public class MockUnparsedNotificationCallback implements UnparsedNotificationCallback {

  private static final long serialVersionUID = 0L;

  /** Whether this handler was called. */
  private boolean wasCalled;

  /** Returns whether this handler was called. */
  public boolean wasCalled() {
    return wasCalled;
  }

  public MockUnparsedNotificationCallback() {}

  @SuppressWarnings("unused")
  public void onNotification(StoredChannel storedChannel, UnparsedNotification notification)
      throws IOException {
    wasCalled = true;
  }
}
