/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/v1/policy.proto

package com.google.iam.v1;

/**
 *
 *
 * <pre>
 * Specifies the audit configuration for a service.
 * The configuration determines which permission types are logged, and what
 * identities, if any, are exempted from logging.
 * An AuditConfig must have one or more AuditLogConfigs.
 * If there are AuditConfigs for both `allServices` and a specific service,
 * the union of the two AuditConfigs is used for that service: the log_types
 * specified in each AuditConfig are enabled, and the exempted_members in each
 * AuditLogConfig are exempted.
 * Example Policy with multiple AuditConfigs:
 *     {
 *       "audit_configs": [
 *         {
 *           "service": "allServices",
 *           "audit_log_configs": [
 *             {
 *               "log_type": "DATA_READ",
 *               "exempted_members": [
 *                 "user:jose&#64;example.com"
 *               ]
 *             },
 *             {
 *               "log_type": "DATA_WRITE"
 *             },
 *             {
 *               "log_type": "ADMIN_READ"
 *             }
 *           ]
 *         },
 *         {
 *           "service": "sampleservice.googleapis.com",
 *           "audit_log_configs": [
 *             {
 *               "log_type": "DATA_READ"
 *             },
 *             {
 *               "log_type": "DATA_WRITE",
 *               "exempted_members": [
 *                 "user:aliya&#64;example.com"
 *               ]
 *             }
 *           ]
 *         }
 *       ]
 *     }
 * For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
 * logging. It also exempts jose&#64;example.com from DATA_READ logging, and
 * aliya&#64;example.com from DATA_WRITE logging.
 * </pre>
 *
 * Protobuf type {@code google.iam.v1.AuditConfig}
 */
public final class AuditConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.v1.AuditConfig)
    AuditConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuditConfig.newBuilder() to construct.
  private AuditConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuditConfig() {
    service_ = "";
    auditLogConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuditConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AuditConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              service_ = s;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                auditLogConfigs_ = new java.util.ArrayList<com.google.iam.v1.AuditLogConfig>();
                mutable_bitField0_ |= 0x00000001;
              }
              auditLogConfigs_.add(
                  input.readMessage(com.google.iam.v1.AuditLogConfig.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        auditLogConfigs_ = java.util.Collections.unmodifiableList(auditLogConfigs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.v1.PolicyProto.internal_static_google_iam_v1_AuditConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.v1.PolicyProto
        .internal_static_google_iam_v1_AuditConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.v1.AuditConfig.class, com.google.iam.v1.AuditConfig.Builder.class);
  }

  public static final int SERVICE_FIELD_NUMBER = 1;
  private volatile java.lang.Object service_;
  /**
   *
   *
   * <pre>
   * Specifies a service that will be enabled for audit logging.
   * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
   * `allServices` is a special value that covers all services.
   * </pre>
   *
   * <code>string service = 1;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a service that will be enabled for audit logging.
   * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
   * `allServices` is a special value that covers all services.
   * </pre>
   *
   * <code>string service = 1;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIT_LOG_CONFIGS_FIELD_NUMBER = 3;
  private java.util.List<com.google.iam.v1.AuditLogConfig> auditLogConfigs_;
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.iam.v1.AuditLogConfig> getAuditLogConfigsList() {
    return auditLogConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.iam.v1.AuditLogConfigOrBuilder>
      getAuditLogConfigsOrBuilderList() {
    return auditLogConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
   */
  @java.lang.Override
  public int getAuditLogConfigsCount() {
    return auditLogConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.AuditLogConfig getAuditLogConfigs(int index) {
    return auditLogConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The configuration for logging of each type of permission.
   * </pre>
   *
   * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
   */
  @java.lang.Override
  public com.google.iam.v1.AuditLogConfigOrBuilder getAuditLogConfigsOrBuilder(int index) {
    return auditLogConfigs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    for (int i = 0; i < auditLogConfigs_.size(); i++) {
      output.writeMessage(3, auditLogConfigs_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    for (int i = 0; i < auditLogConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, auditLogConfigs_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.v1.AuditConfig)) {
      return super.equals(obj);
    }
    com.google.iam.v1.AuditConfig other = (com.google.iam.v1.AuditConfig) obj;

    if (!getService().equals(other.getService())) return false;
    if (!getAuditLogConfigsList().equals(other.getAuditLogConfigsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    if (getAuditLogConfigsCount() > 0) {
      hash = (37 * hash) + AUDIT_LOG_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAuditLogConfigsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.v1.AuditConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.v1.AuditConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.v1.AuditConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.v1.AuditConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.v1.AuditConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the audit configuration for a service.
   * The configuration determines which permission types are logged, and what
   * identities, if any, are exempted from logging.
   * An AuditConfig must have one or more AuditLogConfigs.
   * If there are AuditConfigs for both `allServices` and a specific service,
   * the union of the two AuditConfigs is used for that service: the log_types
   * specified in each AuditConfig are enabled, and the exempted_members in each
   * AuditLogConfig are exempted.
   * Example Policy with multiple AuditConfigs:
   *     {
   *       "audit_configs": [
   *         {
   *           "service": "allServices",
   *           "audit_log_configs": [
   *             {
   *               "log_type": "DATA_READ",
   *               "exempted_members": [
   *                 "user:jose&#64;example.com"
   *               ]
   *             },
   *             {
   *               "log_type": "DATA_WRITE"
   *             },
   *             {
   *               "log_type": "ADMIN_READ"
   *             }
   *           ]
   *         },
   *         {
   *           "service": "sampleservice.googleapis.com",
   *           "audit_log_configs": [
   *             {
   *               "log_type": "DATA_READ"
   *             },
   *             {
   *               "log_type": "DATA_WRITE",
   *               "exempted_members": [
   *                 "user:aliya&#64;example.com"
   *               ]
   *             }
   *           ]
   *         }
   *       ]
   *     }
   * For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
   * logging. It also exempts jose&#64;example.com from DATA_READ logging, and
   * aliya&#64;example.com from DATA_WRITE logging.
   * </pre>
   *
   * Protobuf type {@code google.iam.v1.AuditConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.v1.AuditConfig)
      com.google.iam.v1.AuditConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.v1.PolicyProto.internal_static_google_iam_v1_AuditConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.v1.PolicyProto
          .internal_static_google_iam_v1_AuditConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.v1.AuditConfig.class, com.google.iam.v1.AuditConfig.Builder.class);
    }

    // Construct using com.google.iam.v1.AuditConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAuditLogConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      service_ = "";

      if (auditLogConfigsBuilder_ == null) {
        auditLogConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        auditLogConfigsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.v1.PolicyProto.internal_static_google_iam_v1_AuditConfig_descriptor;
    }

    @java.lang.Override
    public com.google.iam.v1.AuditConfig getDefaultInstanceForType() {
      return com.google.iam.v1.AuditConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.v1.AuditConfig build() {
      com.google.iam.v1.AuditConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.v1.AuditConfig buildPartial() {
      com.google.iam.v1.AuditConfig result = new com.google.iam.v1.AuditConfig(this);
      int from_bitField0_ = bitField0_;
      result.service_ = service_;
      if (auditLogConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          auditLogConfigs_ = java.util.Collections.unmodifiableList(auditLogConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.auditLogConfigs_ = auditLogConfigs_;
      } else {
        result.auditLogConfigs_ = auditLogConfigsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.v1.AuditConfig) {
        return mergeFrom((com.google.iam.v1.AuditConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.v1.AuditConfig other) {
      if (other == com.google.iam.v1.AuditConfig.getDefaultInstance()) return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        onChanged();
      }
      if (auditLogConfigsBuilder_ == null) {
        if (!other.auditLogConfigs_.isEmpty()) {
          if (auditLogConfigs_.isEmpty()) {
            auditLogConfigs_ = other.auditLogConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAuditLogConfigsIsMutable();
            auditLogConfigs_.addAll(other.auditLogConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.auditLogConfigs_.isEmpty()) {
          if (auditLogConfigsBuilder_.isEmpty()) {
            auditLogConfigsBuilder_.dispose();
            auditLogConfigsBuilder_ = null;
            auditLogConfigs_ = other.auditLogConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            auditLogConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAuditLogConfigsFieldBuilder()
                    : null;
          } else {
            auditLogConfigsBuilder_.addAllMessages(other.auditLogConfigs_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.iam.v1.AuditConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.iam.v1.AuditConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging.
     * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
     * `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging.
     * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
     * `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging.
     * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
     * `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      service_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging.
     * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
     * `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {

      service_ = getDefaultInstance().getService();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a service that will be enabled for audit logging.
     * For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
     * `allServices` is a special value that covers all services.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      service_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.iam.v1.AuditLogConfig> auditLogConfigs_ =
        java.util.Collections.emptyList();

    private void ensureAuditLogConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        auditLogConfigs_ =
            new java.util.ArrayList<com.google.iam.v1.AuditLogConfig>(auditLogConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.iam.v1.AuditLogConfig,
            com.google.iam.v1.AuditLogConfig.Builder,
            com.google.iam.v1.AuditLogConfigOrBuilder>
        auditLogConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public java.util.List<com.google.iam.v1.AuditLogConfig> getAuditLogConfigsList() {
      if (auditLogConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(auditLogConfigs_);
      } else {
        return auditLogConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public int getAuditLogConfigsCount() {
      if (auditLogConfigsBuilder_ == null) {
        return auditLogConfigs_.size();
      } else {
        return auditLogConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public com.google.iam.v1.AuditLogConfig getAuditLogConfigs(int index) {
      if (auditLogConfigsBuilder_ == null) {
        return auditLogConfigs_.get(index);
      } else {
        return auditLogConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder setAuditLogConfigs(int index, com.google.iam.v1.AuditLogConfig value) {
      if (auditLogConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.set(index, value);
        onChanged();
      } else {
        auditLogConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder setAuditLogConfigs(
        int index, com.google.iam.v1.AuditLogConfig.Builder builderForValue) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        auditLogConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder addAuditLogConfigs(com.google.iam.v1.AuditLogConfig value) {
      if (auditLogConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(value);
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder addAuditLogConfigs(int index, com.google.iam.v1.AuditLogConfig value) {
      if (auditLogConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(index, value);
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder addAuditLogConfigs(com.google.iam.v1.AuditLogConfig.Builder builderForValue) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder addAuditLogConfigs(
        int index, com.google.iam.v1.AuditLogConfig.Builder builderForValue) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        auditLogConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder addAllAuditLogConfigs(
        java.lang.Iterable<? extends com.google.iam.v1.AuditLogConfig> values) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, auditLogConfigs_);
        onChanged();
      } else {
        auditLogConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder clearAuditLogConfigs() {
      if (auditLogConfigsBuilder_ == null) {
        auditLogConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        auditLogConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public Builder removeAuditLogConfigs(int index) {
      if (auditLogConfigsBuilder_ == null) {
        ensureAuditLogConfigsIsMutable();
        auditLogConfigs_.remove(index);
        onChanged();
      } else {
        auditLogConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public com.google.iam.v1.AuditLogConfig.Builder getAuditLogConfigsBuilder(int index) {
      return getAuditLogConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public com.google.iam.v1.AuditLogConfigOrBuilder getAuditLogConfigsOrBuilder(int index) {
      if (auditLogConfigsBuilder_ == null) {
        return auditLogConfigs_.get(index);
      } else {
        return auditLogConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public java.util.List<? extends com.google.iam.v1.AuditLogConfigOrBuilder>
        getAuditLogConfigsOrBuilderList() {
      if (auditLogConfigsBuilder_ != null) {
        return auditLogConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(auditLogConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public com.google.iam.v1.AuditLogConfig.Builder addAuditLogConfigsBuilder() {
      return getAuditLogConfigsFieldBuilder()
          .addBuilder(com.google.iam.v1.AuditLogConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public com.google.iam.v1.AuditLogConfig.Builder addAuditLogConfigsBuilder(int index) {
      return getAuditLogConfigsFieldBuilder()
          .addBuilder(index, com.google.iam.v1.AuditLogConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configuration for logging of each type of permission.
     * </pre>
     *
     * <code>repeated .google.iam.v1.AuditLogConfig audit_log_configs = 3;</code>
     */
    public java.util.List<com.google.iam.v1.AuditLogConfig.Builder>
        getAuditLogConfigsBuilderList() {
      return getAuditLogConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.iam.v1.AuditLogConfig,
            com.google.iam.v1.AuditLogConfig.Builder,
            com.google.iam.v1.AuditLogConfigOrBuilder>
        getAuditLogConfigsFieldBuilder() {
      if (auditLogConfigsBuilder_ == null) {
        auditLogConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.iam.v1.AuditLogConfig,
                com.google.iam.v1.AuditLogConfig.Builder,
                com.google.iam.v1.AuditLogConfigOrBuilder>(
                auditLogConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        auditLogConfigs_ = null;
      }
      return auditLogConfigsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.v1.AuditConfig)
  }

  // @@protoc_insertion_point(class_scope:google.iam.v1.AuditConfig)
  private static final com.google.iam.v1.AuditConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.v1.AuditConfig();
  }

  public static com.google.iam.v1.AuditConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuditConfig> PARSER =
      new com.google.protobuf.AbstractParser<AuditConfig>() {
        @java.lang.Override
        public AuditConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AuditConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AuditConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuditConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.v1.AuditConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
