/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.common.base.Objects;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;

class ConnectionInfo {
    private final String ipAddress;
    private final String publicIpAddress;
    private final String instanceUid;
    private final String pscDnsName;
    private final X509Certificate clientCertificate;
    private final List<X509Certificate> certificateChain;
    private final X509Certificate caCertificate;

    ConnectionInfo(String ipAddress, String publicIpAddress, String pscDnsName, String instanceUid, X509Certificate clientCertificate, List<X509Certificate> certificateChain, X509Certificate caCertificate) {
        this.ipAddress = ipAddress;
        this.publicIpAddress = publicIpAddress;
        this.pscDnsName = pscDnsName;
        this.instanceUid = instanceUid;
        this.clientCertificate = clientCertificate;
        this.certificateChain = certificateChain;
        this.caCertificate = caCertificate;
    }

    String getIpAddress() {
        return this.ipAddress;
    }

    String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    String getPscDnsName() {
        return this.pscDnsName;
    }

    String getInstanceUid() {
        return this.instanceUid;
    }

    X509Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    Instant getClientCertificateExpiration() {
        return this.clientCertificate.getNotAfter().toInstant();
    }

    Instant getExpiration() {
        return this.getClientCertificateExpiration();
    }

    List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    X509Certificate getCaCertificate() {
        return this.caCertificate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionInfo)) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        return Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.publicIpAddress, (Object)that.publicIpAddress) && Objects.equal((Object)this.pscDnsName, (Object)that.pscDnsName) && Objects.equal((Object)this.instanceUid, (Object)that.instanceUid) && Objects.equal((Object)this.clientCertificate, (Object)that.clientCertificate) && Objects.equal(this.certificateChain, that.certificateChain) && Objects.equal((Object)this.caCertificate, (Object)that.caCertificate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipAddress, this.publicIpAddress, this.pscDnsName, this.instanceUid, this.clientCertificate, this.certificateChain, this.caCertificate});
    }

    public String toString() {
        return "ConnectionInfo{ipAddress='" + this.ipAddress + '\'' + ",publicIpAddress='" + this.publicIpAddress + '\'' + ",pscDnsName='" + this.pscDnsName + '\'' + ", instanceUid='" + this.instanceUid + '\'' + ", clientCertificate=" + this.clientCertificate + ", certificateChain=" + this.certificateChain + ", caCertificate=" + this.caCertificate + '}';
    }
}

