/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.AsyncRateLimiter;
import com.google.cloud.alloydb.ConnectionInfo;
import com.google.cloud.alloydb.ConnectionInfoCache;
import com.google.cloud.alloydb.ConnectionInfoRepository;
import com.google.cloud.alloydb.Refresher;
import com.google.cloud.alloydb.v1alpha.InstanceName;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.security.KeyPair;

class DefaultConnectionInfoCache
implements ConnectionInfoCache {
    private final Refresher refresher;
    private static final long DEFAULT_TIMEOUT_MS = 30000L;

    DefaultConnectionInfoCache(ListeningScheduledExecutorService executor, ConnectionInfoRepository connectionInfoRepo, InstanceName instanceName, KeyPair clientConnectorKeyPair, long minRefreshDelayMs) {
        this.refresher = new Refresher(instanceName.toString(), executor, () -> connectionInfoRepo.getConnectionInfo(instanceName, clientConnectorKeyPair), new AsyncRateLimiter(minRefreshDelayMs));
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.refresher.getConnectionInfo(30000L);
    }

    @Override
    public void forceRefresh() {
        this.refresher.forceRefresh();
    }

    @Override
    public void close() {
        this.refresher.close();
    }

    @Override
    public void refreshIfExpired() {
        this.refresher.refreshIfExpired();
    }
}

