/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import java.time.Duration;
import java.time.Instant;

class RefreshCalculator {
    private static final Duration DEFAULT_REFRESH_BUFFER = Duration.ofMinutes(4L);

    RefreshCalculator() {
    }

    long calculateSecondsUntilNextRefresh(Instant now, Instant expiration) {
        Duration timeUntilExp = Duration.between(now, expiration);
        if (timeUntilExp.compareTo(Duration.ofHours(1L)) < 0) {
            if (timeUntilExp.compareTo(DEFAULT_REFRESH_BUFFER) < 0) {
                return 0L;
            }
            return timeUntilExp.minus(DEFAULT_REFRESH_BUFFER).getSeconds();
        }
        return timeUntilExp.dividedBy(2L).getSeconds();
    }
}

