/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskTypeId;
import java.util.Objects;

public class StandardDiskConfiguration
extends DiskConfiguration {
    private static final long serialVersionUID = -6974045909359567054L;

    private StandardDiskConfiguration(Builder builder) {
        super(builder);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode());
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(StandardDiskConfiguration.class) && this.baseEquals((StandardDiskConfiguration)obj);
    }

    @Override
    StandardDiskConfiguration setProjectId(String projectId) {
        if (this.diskType() == null || this.diskType().project() != null) {
            return this;
        }
        return ((Builder)this.toBuilder().diskType(this.diskType().setProjectId(projectId))).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StandardDiskConfiguration of(DiskTypeId diskType) {
        return ((Builder)StandardDiskConfiguration.builder().diskType(diskType)).build();
    }

    public static StandardDiskConfiguration of(long sizeGb) {
        return StandardDiskConfiguration.builder().sizeGb(sizeGb).build();
    }

    public static StandardDiskConfiguration of(DiskTypeId diskType, long sizeGb) {
        return ((Builder)StandardDiskConfiguration.builder().diskType(diskType)).sizeGb(sizeGb).build();
    }

    static StandardDiskConfiguration fromPb(Disk diskPb) {
        return new Builder(diskPb).build();
    }

    public static class Builder
    extends DiskConfiguration.Builder<StandardDiskConfiguration, Builder> {
        private Builder() {
            super(DiskConfiguration.Type.STANDARD);
        }

        private Builder(StandardDiskConfiguration configuration) {
            super(configuration);
        }

        private Builder(Disk diskPb) {
            super(DiskConfiguration.Type.STANDARD, diskPb);
        }

        @Override
        public Builder sizeGb(Long sizeGb) {
            super.sizeGb(sizeGb);
            return this;
        }

        @Override
        public StandardDiskConfiguration build() {
            return new StandardDiskConfiguration(this);
        }
    }
}

