/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.Schema;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class QueryResult
extends PageImpl<List<FieldValue>> {
    private static final long serialVersionUID = -4831062717210349818L;
    private final boolean cacheHit;
    private final Schema schema;
    private final long totalRows;
    private final long totalBytesProcessed;

    private QueryResult(Builder builder) {
        super((PageImpl.NextPageFetcher)builder.pageFetcher, builder.cursor, builder.results != null ? builder.results : ImmutableList.of());
        this.cacheHit = builder.cacheHit;
        this.schema = builder.schema;
        this.totalBytesProcessed = builder.totalBytesProcessed;
        this.totalRows = builder.totalRows;
    }

    public boolean cacheHit() {
        return this.cacheHit;
    }

    @Deprecated
    public Schema schema() {
        return this.getSchema();
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Deprecated
    public long totalBytesProcessed() {
        return this.getTotalBytesProcessed();
    }

    public long getTotalBytesProcessed() {
        return this.totalBytesProcessed;
    }

    @Deprecated
    public long totalRows() {
        return this.getTotalRows();
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    @Deprecated
    public QueryResult nextPage() {
        return this.getNextPage();
    }

    public QueryResult getNextPage() {
        return (QueryResult)super.getNextPage();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("rows", (Object)this.getValues()).add("cacheHit", this.cacheHit).add("schema", (Object)this.schema).add("totalBytesProcessed", this.totalBytesProcessed).add("totalRows", this.totalRows).add("cursor", (Object)this.getNextPageCursor()).toString();
    }

    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.cacheHit, this.schema, this.totalBytesProcessed, this.totalRows);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(QueryResult.class)) {
            return false;
        }
        QueryResult response = (QueryResult)((Object)obj);
        return Objects.equals(this.getNextPageCursor(), response.getNextPageCursor()) && Objects.equals(this.getValues(), response.getValues()) && Objects.equals(this.schema, response.schema) && this.totalRows == response.totalRows && this.totalBytesProcessed == response.totalBytesProcessed && this.cacheHit == response.cacheHit;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder {
        private QueryResultsPageFetcher pageFetcher;
        private String cursor;
        private Iterable<List<FieldValue>> results;
        private boolean cacheHit;
        private Schema schema;
        private long totalRows;
        private long totalBytesProcessed;

        private Builder() {
        }

        Builder setCacheHit(boolean cacheHit) {
            this.cacheHit = cacheHit;
            return this;
        }

        Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        Builder setTotalBytesProcessed(long totalBytesProcessed) {
            this.totalBytesProcessed = totalBytesProcessed;
            return this;
        }

        Builder setTotalRows(long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        Builder setPageFetcher(QueryResultsPageFetcher pageFetcher) {
            this.pageFetcher = pageFetcher;
            return this;
        }

        Builder setCursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        Builder setResults(Iterable<List<FieldValue>> results) {
            this.results = results;
            return this;
        }

        QueryResult build() {
            return new QueryResult(this);
        }
    }

    static interface QueryResultsPageFetcher
    extends PageImpl.NextPageFetcher<List<FieldValue>> {
        @Deprecated
        public QueryResult nextPage();

        public QueryResult getNextPage();
    }
}

