/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public class Subnetwork
extends SubnetworkInfo {
    private static final long serialVersionUID = 8608280908101278096L;
    private final ComputeOptions options;
    private transient Compute compute;

    Subnetwork(Compute compute, SubnetworkInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.getOptions();
    }

    public boolean exists() {
        return this.reload(Compute.SubnetworkOption.fields(new Compute.SubnetworkField[0])) != null;
    }

    public Subnetwork reload(Compute.SubnetworkOption ... options) {
        return this.compute.getSubnetwork(this.getSubnetworkId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteSubnetwork(this.getSubnetworkId(), options);
    }

    @Deprecated
    public Compute compute() {
        return this.getCompute();
    }

    public Compute getCompute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Subnetwork.class)) {
            return false;
        }
        Subnetwork other = (Subnetwork)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.getService();
    }

    static Subnetwork fromPb(Compute compute, com.google.api.services.compute.model.Subnetwork subnetworkPb) {
        return new Subnetwork(compute, new SubnetworkInfo.BuilderImpl(subnetworkPb));
    }

    public static class Builder
    extends SubnetworkInfo.Builder {
        private final Compute compute;
        private final SubnetworkInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, SubnetworkId subnetworkId, NetworkId networkId, String ipRange) {
            this.compute = compute;
            this.infoBuilder = new SubnetworkInfo.BuilderImpl(subnetworkId, networkId, ipRange);
            this.infoBuilder.setSubnetworkId(subnetworkId);
            this.infoBuilder.setNetwork(networkId);
            this.infoBuilder.setIpRange(ipRange);
        }

        Builder(Subnetwork subnetwork) {
            this.compute = subnetwork.compute;
            this.infoBuilder = new SubnetworkInfo.BuilderImpl(subnetwork);
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setCreationTimestamp(Long creationTimestamp) {
            this.infoBuilder.setCreationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder setSubnetworkId(SubnetworkId subnetworkId) {
            return this.setSubnetworkId(subnetworkId);
        }

        @Override
        public Builder subnetworkId(SubnetworkId subnetworkId) {
            this.infoBuilder.setSubnetworkId(subnetworkId);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            return this.setDescription(description);
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setGatewayAddress(String gatewayAddress) {
            this.infoBuilder.setGatewayAddress(gatewayAddress);
            return this;
        }

        @Override
        public Builder setNetwork(NetworkId network) {
            return this.setNetwork(network);
        }

        @Override
        public Builder network(NetworkId network) {
            this.infoBuilder.setNetwork(network);
            return this;
        }

        @Override
        public Builder setIpRange(String ipRange) {
            return this.setIpRange(ipRange);
        }

        @Override
        public Builder ipRange(String ipRange) {
            this.infoBuilder.setIpRange(ipRange);
            return this;
        }

        @Override
        public Subnetwork build() {
            return new Subnetwork(this.compute, this.infoBuilder);
        }
    }
}

