/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CanonicalExtensionHeadersSerializer {
    private static final char HEADER_SEPARATOR = ':';

    public StringBuilder serialize(Map<String, String> canonicalizedExtensionHeaders) {
        StringBuilder serializedHeaders = new StringBuilder();
        if (canonicalizedExtensionHeaders == null || canonicalizedExtensionHeaders.isEmpty()) {
            return serializedHeaders;
        }
        HashMap<String, String> lowercaseHeaders = new HashMap<String, String>();
        for (String headerName : new ArrayList<String>(canonicalizedExtensionHeaders.keySet())) {
            String lowercaseHeaderName = headerName.toLowerCase();
            if ("x-goog-encryption-key".equals(lowercaseHeaderName) || "x-goog-encryption-key-sha256".equals(lowercaseHeaderName)) continue;
            lowercaseHeaders.put(lowercaseHeaderName, canonicalizedExtensionHeaders.get(headerName));
        }
        ArrayList sortedHeaderNames = new ArrayList(lowercaseHeaders.keySet());
        Collections.sort(sortedHeaderNames);
        for (String headerName : sortedHeaderNames) {
            serializedHeaders.append(headerName).append(':').append(((String)lowercaseHeaders.get(headerName)).trim().replaceAll("[\\s]{2,}", " ").replaceAll("(\\t|\\r?\\n)+", " ")).append('\n');
        }
        return serializedHeaders;
    }
}

