/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.BaseServiceException;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.util.Set;

final class DefaultStorageRetryStrategy
implements StorageRetryStrategy {
    static final DefaultStorageRetryStrategy INSTANCE = new DefaultStorageRetryStrategy();
    private static final long serialVersionUID = 7928177703325504905L;
    private static final ExceptionHandler.Interceptor INTERCEPTOR_IDEMPOTENT = new InterceptorImpl(true, StorageException.RETRYABLE_ERRORS);
    private static final ExceptionHandler.Interceptor INTERCEPTOR_NON_IDEMPOTENT = new InterceptorImpl(false, (Set)ImmutableSet.of());
    private static final ExceptionHandler IDEMPOTENT_HANDLER = DefaultStorageRetryStrategy.newHandler(new EmptyJsonParsingExceptionInterceptor(), INTERCEPTOR_IDEMPOTENT);
    private static final ExceptionHandler NON_IDEMPOTENT_HANDLER = DefaultStorageRetryStrategy.newHandler(INTERCEPTOR_NON_IDEMPOTENT);

    private DefaultStorageRetryStrategy() {
    }

    public ExceptionHandler getIdempotentHandler() {
        return IDEMPOTENT_HANDLER;
    }

    public ExceptionHandler getNonidempotentHandler() {
        return NON_IDEMPOTENT_HANDLER;
    }

    private static ExceptionHandler newHandler(ExceptionHandler.Interceptor ... interceptors) {
        return ExceptionHandler.newBuilder().addInterceptors(interceptors).build();
    }

    private Object readResolve() {
        return INSTANCE;
    }

    private static interface BaseInterceptor
    extends ExceptionHandler.Interceptor {
        default public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }
    }

    private static final class EmptyJsonParsingExceptionInterceptor
    implements BaseInterceptor {
        private static final long serialVersionUID = -3466977370399704805L;

        private EmptyJsonParsingExceptionInterceptor() {
        }

        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            IllegalArgumentException illegalArgumentException;
            if (exception instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)exception).getMessage().equals("no JSON input found")) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }
    }

    private static class InterceptorImpl
    implements BaseInterceptor {
        private static final long serialVersionUID = 5283634944744417128L;
        private final boolean idempotent;
        private final ImmutableSet<BaseServiceException.Error> retryableErrors;

        private InterceptorImpl(boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
            this.idempotent = idempotent;
            this.retryableErrors = ImmutableSet.copyOf(retryableErrors);
        }

        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            if (exception instanceof BaseServiceException) {
                BaseServiceException baseServiceException = (BaseServiceException)exception;
                return this.deepShouldRetry(baseServiceException);
            }
            if (exception instanceof HttpResponseException) {
                int code = ((HttpResponseException)exception).getStatusCode();
                return this.shouldRetryCodeReason(code, null);
            }
            if (exception instanceof IOException) {
                IOException ioException = (IOException)exception;
                return this.shouldRetryIOException(ioException);
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        private ExceptionHandler.Interceptor.RetryResult shouldRetryCodeReason(Integer code, String reason) {
            if (BaseServiceException.isRetryable((Integer)code, (String)reason, (boolean)this.idempotent, this.retryableErrors)) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
        }

        private ExceptionHandler.Interceptor.RetryResult shouldRetryIOException(IOException ioException) {
            if (ioException instanceof JsonEOFException && this.idempotent) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            if (ioException instanceof MalformedJsonException && this.idempotent) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            if (BaseServiceException.isRetryable((boolean)this.idempotent, (IOException)ioException)) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
        }

        private ExceptionHandler.Interceptor.RetryResult deepShouldRetry(BaseServiceException baseServiceException) {
            Throwable cause;
            if (baseServiceException.getCode() == 0 && baseServiceException.getReason() == null && (cause = baseServiceException.getCause()) instanceof IOException) {
                IOException ioException = (IOException)cause;
                return this.shouldRetryIOException(ioException);
            }
            int code = baseServiceException.getCode();
            String reason = baseServiceException.getReason();
            return this.shouldRetryCodeReason(code, reason);
        }
    }
}

