/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.Part;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class ContentMaker {
    private static final String DEFAULT_ROLE = "user";

    public static ContentMakerForRole forRole(String role) {
        return new ContentMakerForRole(role);
    }

    private static Content fromStringWithRole(String role, String text) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (Object)"text message can't be null or empty.");
        return Content.newBuilder().addParts(Part.newBuilder().setText(text)).setRole(role).build();
    }

    private static Content fromMultiModalDataWithRole(String role, Object ... multiModalData) {
        Content.Builder contentBuilder = Content.newBuilder().setRole(role);
        for (Object partData : multiModalData) {
            if (partData instanceof String) {
                String textData = (String)partData;
                contentBuilder.addParts(Part.newBuilder().setText(textData));
                continue;
            }
            if (partData instanceof Part) {
                contentBuilder.addParts((Part)partData);
                continue;
            }
            throw new IllegalArgumentException("Unsupported data type: " + partData.getClass());
        }
        return contentBuilder.build();
    }

    public static Content fromString(String text) {
        return ContentMaker.fromStringWithRole(DEFAULT_ROLE, text);
    }

    public static Content fromMultiModalData(Object ... multiModalData) {
        return ContentMaker.fromMultiModalDataWithRole(DEFAULT_ROLE, multiModalData);
    }

    public static class ContentMakerForRole {
        private String role;

        private ContentMakerForRole(String role) {
            this.role = role;
        }

        public Content fromString(String text) {
            return ContentMaker.fromStringWithRole(this.role, text);
        }

        public Content fromMultiModalData(Object ... multiModalData) {
            return ContentMaker.fromMultiModalDataWithRole(this.role, multiModalData);
        }
    }
}

