/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.util.Strings;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class ByteArrayContent
extends AbstractInputStreamContent {
    private final byte[] byteArray;
    @Deprecated
    private static final byte[] EMPTY_ARRAY = new byte[0];

    @Deprecated
    public ByteArrayContent(byte[] array) {
        this(null, array);
    }

    @Deprecated
    public ByteArrayContent(String contentString) {
        this(Strings.toBytesUtf8(contentString));
    }

    @Deprecated
    public ByteArrayContent() {
        this(EMPTY_ARRAY);
    }

    public ByteArrayContent(String type, byte[] array) {
        super(type);
        this.byteArray = (byte[])Preconditions.checkNotNull((Object)array);
    }

    public static ByteArrayContent fromString(String type, String contentString) {
        return new ByteArrayContent(type, Strings.toBytesUtf8(contentString));
    }

    public long getLength() {
        return this.byteArray.length;
    }

    public boolean retrySupported() {
        return true;
    }

    protected InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArray);
    }

    public ByteArrayContent setEncoding(String encoding) {
        return (ByteArrayContent)super.setEncoding(encoding);
    }

    public ByteArrayContent setType(String type) {
        return (ByteArrayContent)super.setType(type);
    }
}

