/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.xml;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Types;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlHttpParser
implements HttpParser {
    public static final String CONTENT_TYPE = "application/xml";
    @Deprecated
    public String contentType = "application/xml";
    @Deprecated
    public XmlNamespaceDictionary namespaceDictionary;

    @Deprecated
    public XmlHttpParser() {
    }

    public XmlHttpParser(XmlNamespaceDictionary namespaceDictionary) {
        this.namespaceDictionary = (XmlNamespaceDictionary)Preconditions.checkNotNull((Object)namespaceDictionary);
    }

    protected XmlHttpParser(XmlNamespaceDictionary namespaceDictionary, String contentType) {
        this(namespaceDictionary);
        this.contentType = contentType;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        InputStream content = response.getContent();
        try {
            T result = Types.newInstance(dataClass);
            XmlPullParser parser = Xml.createParser();
            parser.setInput(content, null);
            Xml.parseElement(parser, result, this.namespaceDictionary, null);
            T t = result;
            return t;
        }
        catch (XmlPullParserException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            content.close();
        }
    }

    public final XmlNamespaceDictionary getNamespaceDictionary() {
        return this.namespaceDictionary;
    }

    public static Builder builder(XmlNamespaceDictionary namespaceDictionary) {
        return new Builder(namespaceDictionary);
    }

    public static class Builder {
        private String contentType = "application/xml";
        private final XmlNamespaceDictionary namespaceDictionary;

        protected Builder(XmlNamespaceDictionary namespaceDictionary) {
            this.namespaceDictionary = (XmlNamespaceDictionary)Preconditions.checkNotNull((Object)namespaceDictionary);
        }

        public XmlHttpParser build() {
            return new XmlHttpParser(this.namespaceDictionary, this.contentType);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }

        public final XmlNamespaceDictionary getNamespaceDictionary() {
            return this.namespaceDictionary;
        }
    }
}

