/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.JsonEncoding;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonFactory {
    public abstract JsonParser createJsonParser(InputStream var1) throws IOException;

    public abstract JsonParser createJsonParser(String var1) throws IOException;

    public abstract JsonParser createJsonParser(Reader var1) throws IOException;

    public abstract JsonGenerator createJsonGenerator(OutputStream var1, JsonEncoding var2) throws IOException;

    public abstract JsonGenerator createJsonGenerator(Writer var1) throws IOException;

    public final String toString(Object item) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            JsonGenerator generator = this.createJsonGenerator(byteStream, JsonEncoding.UTF8);
            generator.serialize(item);
            generator.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteStream.toString();
    }

    public final <T> T fromString(String value, Class<T> destinationClass) throws IOException {
        return this.createJsonParser(value).parse(destinationClass, null);
    }
}

