/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.ArrayValueMap;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.LoggingInputStream;
import com.google.api.client.util.StringUtils;
import com.google.api.client.util.Types;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpResponse {
    private InputStream content;
    private final String contentEncoding;
    private long contentLength;
    private final String contentType;
    private final HttpHeaders headers;
    private LowLevelHttpResponse response;
    private final int statusCode;
    private final String statusMessage;
    private final HttpTransport transport;
    private final HttpRequest request;
    private int contentLoggingLimit;
    private boolean loggingEnabled;

    HttpResponse(HttpRequest request, LowLevelHttpResponse response) {
        String message;
        int code;
        this.request = request;
        this.transport = request.getTransport();
        this.headers = request.getResponseHeaders();
        this.contentLoggingLimit = request.getContentLoggingLimit();
        this.loggingEnabled = request.isLoggingEnabled();
        this.response = response;
        this.contentLength = response.getContentLength();
        this.contentType = response.getContentType();
        this.contentEncoding = response.getContentEncoding();
        this.statusCode = code = response.getStatusCode();
        this.statusMessage = message = response.getReasonPhrase();
        Logger logger = HttpTransport.LOGGER;
        boolean loggable = this.loggingEnabled && logger.isLoggable(Level.CONFIG);
        StringBuilder logbuf = null;
        if (loggable) {
            logbuf = new StringBuilder();
            logbuf.append("-------------- RESPONSE --------------").append(StringUtils.LINE_SEPARATOR);
            String statusLine = response.getStatusLine();
            if (statusLine != null) {
                logbuf.append(statusLine);
            } else {
                logbuf.append(code);
                if (message != null) {
                    logbuf.append(' ').append(message);
                }
            }
            logbuf.append(StringUtils.LINE_SEPARATOR);
        }
        int size = response.getHeaderCount();
        Class<?> headersClass = this.headers.getClass();
        List<Type> context = Arrays.asList(headersClass);
        ClassInfo classInfo = ClassInfo.of(headersClass);
        HashMap<String, String> fieldNameMap = HttpHeaders.getFieldNameMap(headersClass);
        ArrayValueMap arrayValueMap = new ArrayValueMap(this.headers);
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo;
            String fieldName;
            String headerName = response.getHeaderName(i);
            String headerValue = response.getHeaderValue(i);
            if (loggable) {
                logbuf.append(headerName + ": " + headerValue).append(StringUtils.LINE_SEPARATOR);
            }
            if ((fieldName = fieldNameMap.get(headerName.toLowerCase())) == null) {
                fieldName = headerName;
            }
            if ((fieldInfo = classInfo.getFieldInfo(fieldName)) != null) {
                Type type = Data.resolveWildcardTypeOrTypeVariable(context, fieldInfo.getGenericType());
                if (Types.isArray(type)) {
                    Class<?> rawArrayComponentType = Types.getRawArrayComponentType(context, Types.getArrayComponentType(type));
                    arrayValueMap.put(fieldInfo.getField(), rawArrayComponentType, HttpResponse.parseValue(rawArrayComponentType, context, headerValue));
                    continue;
                }
                if (Types.isAssignableToOrFrom(Types.getRawArrayComponentType(context, type), Iterable.class)) {
                    Collection<Object> collection = (Collection<Object>)fieldInfo.getValue(this.headers);
                    if (collection == null) {
                        collection = Data.newCollectionInstance(type);
                        fieldInfo.setValue(this.headers, collection);
                    }
                    Type subFieldType = type == Object.class ? null : Types.getIterableParameter(type);
                    collection.add(HttpResponse.parseValue(subFieldType, context, headerValue));
                    continue;
                }
                fieldInfo.setValue(this.headers, HttpResponse.parseValue(type, context, headerValue));
                continue;
            }
            ArrayList<String> listValue = (ArrayList<String>)this.headers.get(fieldName);
            if (listValue == null) {
                listValue = new ArrayList<String>();
                this.headers.set(fieldName, listValue);
            }
            listValue.add(headerValue);
        }
        arrayValueMap.setValues();
        if (loggable) {
            logger.config(logbuf.toString());
        }
    }

    public int getContentLoggingLimit() {
        return this.contentLoggingLimit;
    }

    public HttpResponse setContentLoggingLimit(int contentLoggingLimit) {
        Preconditions.checkArgument((contentLoggingLimit >= 0 ? 1 : 0) != 0, (Object)"The content logging limit must be non-negative.");
        this.contentLoggingLimit = contentLoggingLimit;
        return this;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public HttpResponse setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public boolean isSuccessStatusCode() {
        return HttpStatusCodes.isSuccess(this.statusCode);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    private static Object parseValue(Type valueType, List<Type> context, String value) {
        Type resolved = Data.resolveWildcardTypeOrTypeVariable(context, valueType);
        return Data.parsePrimitiveValue(resolved, value);
    }

    public InputStream getContent() throws IOException {
        LowLevelHttpResponse response = this.response;
        if (response == null) {
            return this.content;
        }
        InputStream content = this.response.getContent();
        this.response = null;
        if (content != null) {
            String contentEncoding = this.contentEncoding;
            if (contentEncoding != null && contentEncoding.contains("gzip")) {
                content = new GZIPInputStream(content);
                this.contentLength = -1L;
            }
            Logger logger = HttpTransport.LOGGER;
            if (this.loggingEnabled && logger.isLoggable(Level.CONFIG)) {
                content = new LoggingInputStream(content, logger, Level.CONFIG, this.contentLoggingLimit);
            }
            this.content = content;
        }
        return content;
    }

    public void download(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.getContent();
        AbstractInputStreamContent.copy(inputStream, outputStream);
    }

    public void ignore() throws IOException {
        InputStream content = this.getContent();
        if (content != null) {
            content.close();
        }
    }

    public void disconnect() throws IOException {
        this.response.disconnect();
    }

    public HttpParser getParser() {
        return this.request.getParser(this.contentType);
    }

    public <T> T parseAs(Class<T> dataClass) throws IOException {
        HttpParser parser = this.getParser();
        if (parser == null) {
            Preconditions.checkArgument((this.contentType != null ? 1 : 0) != 0, (Object)"Missing Content-Type header in response");
            throw new IllegalArgumentException("No parser defined for Content-Type: " + this.contentType);
        }
        return parser.parse(this, dataClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseAsString() throws IOException {
        InputStream content = this.getContent();
        if (content == null) {
            return "";
        }
        try {
            int bytesRead;
            long contentLength = this.contentLength;
            int bufferSize = contentLength == -1L ? 4096 : (int)contentLength;
            int length = 0;
            byte[] buffer = new byte[bufferSize];
            byte[] tmp = new byte[4096];
            while ((bytesRead = content.read(tmp)) != -1) {
                if (length + bytesRead > bufferSize) {
                    bufferSize = Math.max(bufferSize << 1, length + bytesRead);
                    byte[] newbuffer = new byte[bufferSize];
                    System.arraycopy(buffer, 0, newbuffer, 0, length);
                    buffer = newbuffer;
                }
                System.arraycopy(tmp, 0, buffer, length, bytesRead);
                length += bytesRead;
            }
            String string = new String(buffer, 0, length, "UTF-8");
            return string;
        }
        finally {
            content.close();
        }
    }
}

