/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.places.v1.AutocompletePlacesRequest;
import com.google.maps.places.v1.AutocompletePlacesResponse;
import com.google.maps.places.v1.GetPhotoMediaRequest;
import com.google.maps.places.v1.GetPlaceRequest;
import com.google.maps.places.v1.PhotoMedia;
import com.google.maps.places.v1.Place;
import com.google.maps.places.v1.SearchNearbyRequest;
import com.google.maps.places.v1.SearchNearbyResponse;
import com.google.maps.places.v1.SearchTextRequest;
import com.google.maps.places.v1.SearchTextResponse;
import com.google.maps.places.v1.stub.HttpJsonPlacesCallableFactory;
import com.google.maps.places.v1.stub.PlacesStub;
import com.google.maps.places.v1.stub.PlacesStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonPlacesStub
extends PlacesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<SearchNearbyRequest, SearchNearbyResponse> searchNearbyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.places.v1.Places/SearchNearby").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/places:searchNearby", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchNearbyResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchTextRequest, SearchTextResponse> searchTextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.places.v1.Places/SearchText").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/places:searchText", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchTextResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.places.v1.Places/GetPhotoMedia").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=places/*/photos/*/media}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "maxHeightPx", (Object)request.getMaxHeightPx());
        serializer.putQueryParam(fields, "maxWidthPx", (Object)request.getMaxWidthPx());
        serializer.putQueryParam(fields, "skipHttpRedirect", (Object)request.getSkipHttpRedirect());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PhotoMedia.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetPlaceRequest, Place> getPlaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.places.v1.Places/GetPlace").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=places/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "regionCode", (Object)request.getRegionCode());
        serializer.putQueryParam(fields, "sessionToken", (Object)request.getSessionToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Place.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.places.v1.Places/AutocompletePlaces").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/places:autocomplete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AutocompletePlacesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<SearchNearbyRequest, SearchNearbyResponse> searchNearbyCallable;
    private final UnaryCallable<SearchTextRequest, SearchTextResponse> searchTextCallable;
    private final UnaryCallable<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaCallable;
    private final UnaryCallable<GetPlaceRequest, Place> getPlaceCallable;
    private final UnaryCallable<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPlacesStub create(PlacesStubSettings settings) throws IOException {
        return new HttpJsonPlacesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPlacesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPlacesStub(PlacesStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPlacesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPlacesStub(PlacesStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPlacesStub(PlacesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPlacesCallableFactory());
    }

    protected HttpJsonPlacesStub(PlacesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings searchNearbyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchNearbyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchTextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchTextMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getPhotoMediaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPhotoMediaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getPlaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPlaceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings autocompletePlacesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(autocompletePlacesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.searchNearbyCallable = callableFactory.createUnaryCallable(searchNearbyTransportSettings, settings.searchNearbySettings(), clientContext);
        this.searchTextCallable = callableFactory.createUnaryCallable(searchTextTransportSettings, settings.searchTextSettings(), clientContext);
        this.getPhotoMediaCallable = callableFactory.createUnaryCallable(getPhotoMediaTransportSettings, settings.getPhotoMediaSettings(), clientContext);
        this.getPlaceCallable = callableFactory.createUnaryCallable(getPlaceTransportSettings, settings.getPlaceSettings(), clientContext);
        this.autocompletePlacesCallable = callableFactory.createUnaryCallable(autocompletePlacesTransportSettings, settings.autocompletePlacesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(searchNearbyMethodDescriptor);
        methodDescriptors.add(searchTextMethodDescriptor);
        methodDescriptors.add(getPhotoMediaMethodDescriptor);
        methodDescriptors.add(getPlaceMethodDescriptor);
        methodDescriptors.add(autocompletePlacesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<SearchNearbyRequest, SearchNearbyResponse> searchNearbyCallable() {
        return this.searchNearbyCallable;
    }

    @Override
    public UnaryCallable<SearchTextRequest, SearchTextResponse> searchTextCallable() {
        return this.searchTextCallable;
    }

    @Override
    public UnaryCallable<GetPhotoMediaRequest, PhotoMedia> getPhotoMediaCallable() {
        return this.getPhotoMediaCallable;
    }

    @Override
    public UnaryCallable<GetPlaceRequest, Place> getPlaceCallable() {
        return this.getPlaceCallable;
    }

    @Override
    public UnaryCallable<AutocompletePlacesRequest, AutocompletePlacesResponse> autocompletePlacesCallable() {
        return this.autocompletePlacesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

